package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LaunchTemplateTagSpecification(
    resourceType: Option[zio.aws.ec2.model.ResourceType] = None,
    tags: Option[Iterable[zio.aws.ec2.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.LaunchTemplateTagSpecification = {
    import LaunchTemplateTagSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.LaunchTemplateTagSpecification
      .builder()
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.LaunchTemplateTagSpecification.ReadOnly =
    zio.aws.ec2.model.LaunchTemplateTagSpecification.wrap(buildAwsValue())
}
object LaunchTemplateTagSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.LaunchTemplateTagSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.LaunchTemplateTagSpecification =
      zio.aws.ec2.model.LaunchTemplateTagSpecification(
        resourceType.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def resourceType: Option[zio.aws.ec2.model.ResourceType]
    def tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getResourceType: ZIO[Any, AwsError, zio.aws.ec2.model.ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.LaunchTemplateTagSpecification
  ) extends zio.aws.ec2.model.LaunchTemplateTagSpecification.ReadOnly {
    override val resourceType: Option[zio.aws.ec2.model.ResourceType] = scala
      .Option(impl.resourceType())
      .map(value => zio.aws.ec2.model.ResourceType.wrap(value))
    override val tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.LaunchTemplateTagSpecification
  ): zio.aws.ec2.model.LaunchTemplateTagSpecification.ReadOnly = new Wrapper(
    impl
  )
}
