package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LaunchTemplateElasticInferenceAcceleratorResponse(
    `type`: Option[String] = None,
    count: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.LaunchTemplateElasticInferenceAcceleratorResponse = {
    import LaunchTemplateElasticInferenceAcceleratorResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.LaunchTemplateElasticInferenceAcceleratorResponse
      .builder()
      .optionallyWith(`type`.map(value => value: java.lang.String))(_.`type`)
      .optionallyWith(count.map(value => value: java.lang.Integer))(_.count)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.LaunchTemplateElasticInferenceAcceleratorResponse.ReadOnly =
    zio.aws.ec2.model.LaunchTemplateElasticInferenceAcceleratorResponse
      .wrap(buildAwsValue())
}
object LaunchTemplateElasticInferenceAcceleratorResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.LaunchTemplateElasticInferenceAcceleratorResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.LaunchTemplateElasticInferenceAcceleratorResponse =
      zio.aws.ec2.model.LaunchTemplateElasticInferenceAcceleratorResponse(
        `type`.map(value => value),
        count.map(value => value)
      )
    def `type`: Option[String]
    def count: Option[Integer]
    def getType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("type", `type`)
    def getCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("count", count)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.LaunchTemplateElasticInferenceAcceleratorResponse
  ) extends zio.aws.ec2.model.LaunchTemplateElasticInferenceAcceleratorResponse.ReadOnly {
    override val `type`: Option[String] =
      scala.Option(impl.`type`()).map(value => value: String)
    override val count: Option[Integer] =
      scala.Option(impl.count()).map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.LaunchTemplateElasticInferenceAcceleratorResponse
  ): zio.aws.ec2.model.LaunchTemplateElasticInferenceAcceleratorResponse.ReadOnly =
    new Wrapper(impl)
}
