package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait IpamManagementState {
  def unwrap: software.amazon.awssdk.services.ec2.model.IpamManagementState
}
object IpamManagementState {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.IpamManagementState
  ): zio.aws.ec2.model.IpamManagementState = value match {
    case software.amazon.awssdk.services.ec2.model.IpamManagementState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.IpamManagementState.MANAGED =>
      val r = managed
      r
    case software.amazon.awssdk.services.ec2.model.IpamManagementState.UNMANAGED =>
      val r = unmanaged
      r
    case software.amazon.awssdk.services.ec2.model.IpamManagementState.IGNORED =>
      val r = ignored
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.IpamManagementState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamManagementState =
      software.amazon.awssdk.services.ec2.model.IpamManagementState.UNKNOWN_TO_SDK_VERSION
  }
  case object managed extends zio.aws.ec2.model.IpamManagementState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamManagementState =
      software.amazon.awssdk.services.ec2.model.IpamManagementState.MANAGED
  }
  case object unmanaged extends zio.aws.ec2.model.IpamManagementState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamManagementState =
      software.amazon.awssdk.services.ec2.model.IpamManagementState.UNMANAGED
  }
  case object ignored extends zio.aws.ec2.model.IpamManagementState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamManagementState =
      software.amazon.awssdk.services.ec2.model.IpamManagementState.IGNORED
  }
}
