package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait InstanceStateName {
  def unwrap: software.amazon.awssdk.services.ec2.model.InstanceStateName
}
object InstanceStateName {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.InstanceStateName
  ): zio.aws.ec2.model.InstanceStateName = value match {
    case software.amazon.awssdk.services.ec2.model.InstanceStateName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.InstanceStateName.PENDING =>
      val r = pending
      r
    case software.amazon.awssdk.services.ec2.model.InstanceStateName.RUNNING =>
      val r = running
      r
    case software.amazon.awssdk.services.ec2.model.InstanceStateName.SHUTTING_DOWN =>
      val r = `shutting-down`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceStateName.TERMINATED =>
      val r = terminated
      r
    case software.amazon.awssdk.services.ec2.model.InstanceStateName.STOPPING =>
      val r = stopping
      r
    case software.amazon.awssdk.services.ec2.model.InstanceStateName.STOPPED =>
      val r = stopped
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.InstanceStateName {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceStateName =
      software.amazon.awssdk.services.ec2.model.InstanceStateName.UNKNOWN_TO_SDK_VERSION
  }
  case object pending extends zio.aws.ec2.model.InstanceStateName {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceStateName =
      software.amazon.awssdk.services.ec2.model.InstanceStateName.PENDING
  }
  case object running extends zio.aws.ec2.model.InstanceStateName {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceStateName =
      software.amazon.awssdk.services.ec2.model.InstanceStateName.RUNNING
  }
  case object `shutting-down` extends zio.aws.ec2.model.InstanceStateName {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceStateName =
      software.amazon.awssdk.services.ec2.model.InstanceStateName.SHUTTING_DOWN
  }
  case object terminated extends zio.aws.ec2.model.InstanceStateName {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceStateName =
      software.amazon.awssdk.services.ec2.model.InstanceStateName.TERMINATED
  }
  case object stopping extends zio.aws.ec2.model.InstanceStateName {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceStateName =
      software.amazon.awssdk.services.ec2.model.InstanceStateName.STOPPING
  }
  case object stopped extends zio.aws.ec2.model.InstanceStateName {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceStateName =
      software.amazon.awssdk.services.ec2.model.InstanceStateName.STOPPED
  }
}
