package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait InstanceMetadataProtocolState {
  def unwrap
      : software.amazon.awssdk.services.ec2.model.InstanceMetadataProtocolState
}
object InstanceMetadataProtocolState {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.InstanceMetadataProtocolState
  ): zio.aws.ec2.model.InstanceMetadataProtocolState = value match {
    case software.amazon.awssdk.services.ec2.model.InstanceMetadataProtocolState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.InstanceMetadataProtocolState.DISABLED =>
      val r = disabled
      r
    case software.amazon.awssdk.services.ec2.model.InstanceMetadataProtocolState.ENABLED =>
      val r = enabled
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.InstanceMetadataProtocolState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceMetadataProtocolState =
      software.amazon.awssdk.services.ec2.model.InstanceMetadataProtocolState.UNKNOWN_TO_SDK_VERSION
  }
  case object disabled extends zio.aws.ec2.model.InstanceMetadataProtocolState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceMetadataProtocolState =
      software.amazon.awssdk.services.ec2.model.InstanceMetadataProtocolState.DISABLED
  }
  case object enabled extends zio.aws.ec2.model.InstanceMetadataProtocolState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceMetadataProtocolState =
      software.amazon.awssdk.services.ec2.model.InstanceMetadataProtocolState.ENABLED
  }
}
