package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.FpgaDeviceMemorySize
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class FpgaDeviceMemoryInfo(
    sizeInMiB: Option[FpgaDeviceMemorySize] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.FpgaDeviceMemoryInfo = {
    import FpgaDeviceMemoryInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.FpgaDeviceMemoryInfo
      .builder()
      .optionallyWith(
        sizeInMiB.map(value => FpgaDeviceMemorySize.unwrap(value): Integer)
      )(_.sizeInMiB)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.FpgaDeviceMemoryInfo.ReadOnly =
    zio.aws.ec2.model.FpgaDeviceMemoryInfo.wrap(buildAwsValue())
}
object FpgaDeviceMemoryInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.FpgaDeviceMemoryInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.FpgaDeviceMemoryInfo =
      zio.aws.ec2.model.FpgaDeviceMemoryInfo(sizeInMiB.map(value => value))
    def sizeInMiB: Option[FpgaDeviceMemorySize]
    def getSizeInMiB: ZIO[Any, AwsError, FpgaDeviceMemorySize] =
      AwsError.unwrapOptionField("sizeInMiB", sizeInMiB)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.FpgaDeviceMemoryInfo
  ) extends zio.aws.ec2.model.FpgaDeviceMemoryInfo.ReadOnly {
    override val sizeInMiB: Option[FpgaDeviceMemorySize] = scala
      .Option(impl.sizeInMiB())
      .map(value => zio.aws.ec2.model.primitives.FpgaDeviceMemorySize(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.FpgaDeviceMemoryInfo
  ): zio.aws.ec2.model.FpgaDeviceMemoryInfo.ReadOnly = new Wrapper(impl)
}
