package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class FleetSpotCapacityRebalanceRequest(
    replacementStrategy: Option[zio.aws.ec2.model.FleetReplacementStrategy] =
      None,
    terminationDelay: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.FleetSpotCapacityRebalanceRequest = {
    import FleetSpotCapacityRebalanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.FleetSpotCapacityRebalanceRequest
      .builder()
      .optionallyWith(replacementStrategy.map(value => value.unwrap))(
        _.replacementStrategy
      )
      .optionallyWith(terminationDelay.map(value => value: java.lang.Integer))(
        _.terminationDelay
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.FleetSpotCapacityRebalanceRequest.ReadOnly =
    zio.aws.ec2.model.FleetSpotCapacityRebalanceRequest.wrap(buildAwsValue())
}
object FleetSpotCapacityRebalanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.FleetSpotCapacityRebalanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.FleetSpotCapacityRebalanceRequest =
      zio.aws.ec2.model.FleetSpotCapacityRebalanceRequest(
        replacementStrategy.map(value => value),
        terminationDelay.map(value => value)
      )
    def replacementStrategy: Option[zio.aws.ec2.model.FleetReplacementStrategy]
    def terminationDelay: Option[Integer]
    def getReplacementStrategy
        : ZIO[Any, AwsError, zio.aws.ec2.model.FleetReplacementStrategy] =
      AwsError.unwrapOptionField("replacementStrategy", replacementStrategy)
    def getTerminationDelay: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("terminationDelay", terminationDelay)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.FleetSpotCapacityRebalanceRequest
  ) extends zio.aws.ec2.model.FleetSpotCapacityRebalanceRequest.ReadOnly {
    override val replacementStrategy
        : Option[zio.aws.ec2.model.FleetReplacementStrategy] = scala
      .Option(impl.replacementStrategy())
      .map(value => zio.aws.ec2.model.FleetReplacementStrategy.wrap(value))
    override val terminationDelay: Option[Integer] =
      scala.Option(impl.terminationDelay()).map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.FleetSpotCapacityRebalanceRequest
  ): zio.aws.ec2.model.FleetSpotCapacityRebalanceRequest.ReadOnly = new Wrapper(
    impl
  )
}
