package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ExportImageTask(
    description: Option[String] = None,
    exportImageTaskId: Option[String] = None,
    imageId: Option[String] = None,
    progress: Option[String] = None,
    s3ExportLocation: Option[zio.aws.ec2.model.ExportTaskS3Location] = None,
    status: Option[String] = None,
    statusMessage: Option[String] = None,
    tags: Option[Iterable[zio.aws.ec2.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ExportImageTask = {
    import ExportImageTask.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ExportImageTask
      .builder()
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(exportImageTaskId.map(value => value: java.lang.String))(
        _.exportImageTaskId
      )
      .optionallyWith(imageId.map(value => value: java.lang.String))(_.imageId)
      .optionallyWith(progress.map(value => value: java.lang.String))(
        _.progress
      )
      .optionallyWith(s3ExportLocation.map(value => value.buildAwsValue()))(
        _.s3ExportLocation
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ExportImageTask.ReadOnly =
    zio.aws.ec2.model.ExportImageTask.wrap(buildAwsValue())
}
object ExportImageTask {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ExportImageTask
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ExportImageTask =
      zio.aws.ec2.model.ExportImageTask(
        description.map(value => value),
        exportImageTaskId.map(value => value),
        imageId.map(value => value),
        progress.map(value => value),
        s3ExportLocation.map(value => value.asEditable),
        status.map(value => value),
        statusMessage.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def description: Option[String]
    def exportImageTaskId: Option[String]
    def imageId: Option[String]
    def progress: Option[String]
    def s3ExportLocation
        : Option[zio.aws.ec2.model.ExportTaskS3Location.ReadOnly]
    def status: Option[String]
    def statusMessage: Option[String]
    def tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getExportImageTaskId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("exportImageTaskId", exportImageTaskId)
    def getImageId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("imageId", imageId)
    def getProgress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("progress", progress)
    def getS3ExportLocation
        : ZIO[Any, AwsError, zio.aws.ec2.model.ExportTaskS3Location.ReadOnly] =
      AwsError.unwrapOptionField("s3ExportLocation", s3ExportLocation)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ExportImageTask
  ) extends zio.aws.ec2.model.ExportImageTask.ReadOnly {
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val exportImageTaskId: Option[String] =
      scala.Option(impl.exportImageTaskId()).map(value => value: String)
    override val imageId: Option[String] =
      scala.Option(impl.imageId()).map(value => value: String)
    override val progress: Option[String] =
      scala.Option(impl.progress()).map(value => value: String)
    override val s3ExportLocation
        : Option[zio.aws.ec2.model.ExportTaskS3Location.ReadOnly] = scala
      .Option(impl.s3ExportLocation())
      .map(value => zio.aws.ec2.model.ExportTaskS3Location.wrap(value))
    override val status: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override val statusMessage: Option[String] =
      scala.Option(impl.statusMessage()).map(value => value: String)
    override val tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ExportImageTask
  ): zio.aws.ec2.model.ExportImageTask.ReadOnly = new Wrapper(impl)
}
