package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeReservedInstancesResponse(
    reservedInstances: Option[Iterable[zio.aws.ec2.model.ReservedInstances]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesResponse = {
    import DescribeReservedInstancesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesResponse
      .builder()
      .optionallyWith(
        reservedInstances.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.reservedInstances)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeReservedInstancesResponse.ReadOnly =
    zio.aws.ec2.model.DescribeReservedInstancesResponse.wrap(buildAwsValue())
}
object DescribeReservedInstancesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeReservedInstancesResponse =
      zio.aws.ec2.model.DescribeReservedInstancesResponse(
        reservedInstances.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def reservedInstances
        : Option[List[zio.aws.ec2.model.ReservedInstances.ReadOnly]]
    def getReservedInstances: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.ReservedInstances.ReadOnly
    ]] = AwsError.unwrapOptionField("reservedInstances", reservedInstances)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesResponse
  ) extends zio.aws.ec2.model.DescribeReservedInstancesResponse.ReadOnly {
    override val reservedInstances
        : Option[List[zio.aws.ec2.model.ReservedInstances.ReadOnly]] = scala
      .Option(impl.reservedInstances())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.ReservedInstances.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesResponse
  ): zio.aws.ec2.model.DescribeReservedInstancesResponse.ReadOnly = new Wrapper(
    impl
  )
}
