package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.{ResultRange, InstanceEventWindowId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeInstanceEventWindowsRequest(
    instanceEventWindowIds: Option[Iterable[InstanceEventWindowId]] = None,
    filters: Option[Iterable[zio.aws.ec2.model.Filter]] = None,
    maxResults: Option[ResultRange] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeInstanceEventWindowsRequest = {
    import DescribeInstanceEventWindowsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeInstanceEventWindowsRequest
      .builder()
      .optionallyWith(
        instanceEventWindowIds.map(value =>
          value.map { item =>
            InstanceEventWindowId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.instanceEventWindowIds)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value => ResultRange.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeInstanceEventWindowsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeInstanceEventWindowsRequest.wrap(buildAwsValue())
}
object DescribeInstanceEventWindowsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeInstanceEventWindowsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeInstanceEventWindowsRequest =
      zio.aws.ec2.model.DescribeInstanceEventWindowsRequest(
        instanceEventWindowIds.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def instanceEventWindowIds: Option[List[InstanceEventWindowId]]
    def filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def maxResults: Option[ResultRange]
    def nextToken: Option[String]
    def getInstanceEventWindowIds
        : ZIO[Any, AwsError, List[InstanceEventWindowId]] = AwsError
      .unwrapOptionField("instanceEventWindowIds", instanceEventWindowIds)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, ResultRange] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeInstanceEventWindowsRequest
  ) extends zio.aws.ec2.model.DescribeInstanceEventWindowsRequest.ReadOnly {
    override val instanceEventWindowIds: Option[List[InstanceEventWindowId]] =
      scala
        .Option(impl.instanceEventWindowIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.InstanceEventWindowId(item)
          }.toList
        )
    override val filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val maxResults: Option[ResultRange] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.ec2.model.primitives.ResultRange(value))
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeInstanceEventWindowsRequest
  ): zio.aws.ec2.model.DescribeInstanceEventWindowsRequest.ReadOnly =
    new Wrapper(impl)
}
