package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.{CoipPoolMaxResults, Ipv4PoolCoipId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeCoipPoolsRequest(
    poolIds: Option[Iterable[Ipv4PoolCoipId]] = None,
    filters: Option[Iterable[zio.aws.ec2.model.Filter]] = None,
    maxResults: Option[CoipPoolMaxResults] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeCoipPoolsRequest = {
    import DescribeCoipPoolsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeCoipPoolsRequest
      .builder()
      .optionallyWith(
        poolIds.map(value =>
          value.map { item =>
            Ipv4PoolCoipId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.poolIds)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value => CoipPoolMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeCoipPoolsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeCoipPoolsRequest.wrap(buildAwsValue())
}
object DescribeCoipPoolsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeCoipPoolsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeCoipPoolsRequest =
      zio.aws.ec2.model.DescribeCoipPoolsRequest(
        poolIds.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def poolIds: Option[List[Ipv4PoolCoipId]]
    def filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def maxResults: Option[CoipPoolMaxResults]
    def nextToken: Option[String]
    def getPoolIds: ZIO[Any, AwsError, List[Ipv4PoolCoipId]] =
      AwsError.unwrapOptionField("poolIds", poolIds)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, CoipPoolMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeCoipPoolsRequest
  ) extends zio.aws.ec2.model.DescribeCoipPoolsRequest.ReadOnly {
    override val poolIds: Option[List[Ipv4PoolCoipId]] = scala
      .Option(impl.poolIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.Ipv4PoolCoipId(item)
        }.toList
      )
    override val filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val maxResults: Option[CoipPoolMaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.ec2.model.primitives.CoipPoolMaxResults(value))
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeCoipPoolsRequest
  ): zio.aws.ec2.model.DescribeCoipPoolsRequest.ReadOnly = new Wrapper(impl)
}
