package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.FleetId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteFleetSuccessItem(
    currentFleetState: Option[zio.aws.ec2.model.FleetStateCode] = None,
    previousFleetState: Option[zio.aws.ec2.model.FleetStateCode] = None,
    fleetId: Option[FleetId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteFleetSuccessItem = {
    import DeleteFleetSuccessItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteFleetSuccessItem
      .builder()
      .optionallyWith(currentFleetState.map(value => value.unwrap))(
        _.currentFleetState
      )
      .optionallyWith(previousFleetState.map(value => value.unwrap))(
        _.previousFleetState
      )
      .optionallyWith(
        fleetId.map(value => FleetId.unwrap(value): java.lang.String)
      )(_.fleetId)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteFleetSuccessItem.ReadOnly =
    zio.aws.ec2.model.DeleteFleetSuccessItem.wrap(buildAwsValue())
}
object DeleteFleetSuccessItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteFleetSuccessItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteFleetSuccessItem =
      zio.aws.ec2.model.DeleteFleetSuccessItem(
        currentFleetState.map(value => value),
        previousFleetState.map(value => value),
        fleetId.map(value => value)
      )
    def currentFleetState: Option[zio.aws.ec2.model.FleetStateCode]
    def previousFleetState: Option[zio.aws.ec2.model.FleetStateCode]
    def fleetId: Option[FleetId]
    def getCurrentFleetState
        : ZIO[Any, AwsError, zio.aws.ec2.model.FleetStateCode] =
      AwsError.unwrapOptionField("currentFleetState", currentFleetState)
    def getPreviousFleetState
        : ZIO[Any, AwsError, zio.aws.ec2.model.FleetStateCode] =
      AwsError.unwrapOptionField("previousFleetState", previousFleetState)
    def getFleetId: ZIO[Any, AwsError, FleetId] =
      AwsError.unwrapOptionField("fleetId", fleetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteFleetSuccessItem
  ) extends zio.aws.ec2.model.DeleteFleetSuccessItem.ReadOnly {
    override val currentFleetState: Option[zio.aws.ec2.model.FleetStateCode] =
      scala
        .Option(impl.currentFleetState())
        .map(value => zio.aws.ec2.model.FleetStateCode.wrap(value))
    override val previousFleetState: Option[zio.aws.ec2.model.FleetStateCode] =
      scala
        .Option(impl.previousFleetState())
        .map(value => zio.aws.ec2.model.FleetStateCode.wrap(value))
    override val fleetId: Option[FleetId] = scala
      .Option(impl.fleetId())
      .map(value => zio.aws.ec2.model.primitives.FleetId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteFleetSuccessItem
  ): zio.aws.ec2.model.DeleteFleetSuccessItem.ReadOnly = new Wrapper(impl)
}
