package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateTrafficMirrorFilterRuleResponse(
    trafficMirrorFilterRule: Option[zio.aws.ec2.model.TrafficMirrorFilterRule] =
      None,
    clientToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorFilterRuleResponse = {
    import CreateTrafficMirrorFilterRuleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorFilterRuleResponse
      .builder()
      .optionallyWith(
        trafficMirrorFilterRule.map(value => value.buildAwsValue())
      )(_.trafficMirrorFilterRule)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CreateTrafficMirrorFilterRuleResponse.ReadOnly =
    zio.aws.ec2.model.CreateTrafficMirrorFilterRuleResponse
      .wrap(buildAwsValue())
}
object CreateTrafficMirrorFilterRuleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorFilterRuleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateTrafficMirrorFilterRuleResponse =
      zio.aws.ec2.model.CreateTrafficMirrorFilterRuleResponse(
        trafficMirrorFilterRule.map(value => value.asEditable),
        clientToken.map(value => value)
      )
    def trafficMirrorFilterRule
        : Option[zio.aws.ec2.model.TrafficMirrorFilterRule.ReadOnly]
    def clientToken: Option[String]
    def getTrafficMirrorFilterRule: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TrafficMirrorFilterRule.ReadOnly
    ] = AwsError.unwrapOptionField(
      "trafficMirrorFilterRule",
      trafficMirrorFilterRule
    )
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorFilterRuleResponse
  ) extends zio.aws.ec2.model.CreateTrafficMirrorFilterRuleResponse.ReadOnly {
    override val trafficMirrorFilterRule
        : Option[zio.aws.ec2.model.TrafficMirrorFilterRule.ReadOnly] = scala
      .Option(impl.trafficMirrorFilterRule())
      .map(value => zio.aws.ec2.model.TrafficMirrorFilterRule.wrap(value))
    override val clientToken: Option[String] =
      scala.Option(impl.clientToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorFilterRuleResponse
  ): zio.aws.ec2.model.CreateTrafficMirrorFilterRuleResponse.ReadOnly =
    new Wrapper(impl)
}
