package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateIpamPoolResponse(
    ipamPool: Option[zio.aws.ec2.model.IpamPool] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateIpamPoolResponse = {
    import CreateIpamPoolResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateIpamPoolResponse
      .builder()
      .optionallyWith(ipamPool.map(value => value.buildAwsValue()))(_.ipamPool)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateIpamPoolResponse.ReadOnly =
    zio.aws.ec2.model.CreateIpamPoolResponse.wrap(buildAwsValue())
}
object CreateIpamPoolResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateIpamPoolResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateIpamPoolResponse = zio.aws.ec2.model
      .CreateIpamPoolResponse(ipamPool.map(value => value.asEditable))
    def ipamPool: Option[zio.aws.ec2.model.IpamPool.ReadOnly]
    def getIpamPool: ZIO[Any, AwsError, zio.aws.ec2.model.IpamPool.ReadOnly] =
      AwsError.unwrapOptionField("ipamPool", ipamPool)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateIpamPoolResponse
  ) extends zio.aws.ec2.model.CreateIpamPoolResponse.ReadOnly {
    override val ipamPool: Option[zio.aws.ec2.model.IpamPool.ReadOnly] = scala
      .Option(impl.ipamPool())
      .map(value => zio.aws.ec2.model.IpamPool.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateIpamPoolResponse
  ): zio.aws.ec2.model.CreateIpamPoolResponse.ReadOnly = new Wrapper(impl)
}
