package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ConnectionNotification(
    connectionNotificationId: Option[String] = None,
    serviceId: Option[String] = None,
    vpcEndpointId: Option[String] = None,
    connectionNotificationType: Option[
      zio.aws.ec2.model.ConnectionNotificationType
    ] = None,
    connectionNotificationArn: Option[String] = None,
    connectionEvents: Option[Iterable[String]] = None,
    connectionNotificationState: Option[
      zio.aws.ec2.model.ConnectionNotificationState
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ConnectionNotification = {
    import ConnectionNotification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ConnectionNotification
      .builder()
      .optionallyWith(
        connectionNotificationId.map(value => value: java.lang.String)
      )(_.connectionNotificationId)
      .optionallyWith(serviceId.map(value => value: java.lang.String))(
        _.serviceId
      )
      .optionallyWith(vpcEndpointId.map(value => value: java.lang.String))(
        _.vpcEndpointId
      )
      .optionallyWith(connectionNotificationType.map(value => value.unwrap))(
        _.connectionNotificationType
      )
      .optionallyWith(
        connectionNotificationArn.map(value => value: java.lang.String)
      )(_.connectionNotificationArn)
      .optionallyWith(
        connectionEvents.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.connectionEvents)
      .optionallyWith(connectionNotificationState.map(value => value.unwrap))(
        _.connectionNotificationState
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ConnectionNotification.ReadOnly =
    zio.aws.ec2.model.ConnectionNotification.wrap(buildAwsValue())
}
object ConnectionNotification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ConnectionNotification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ConnectionNotification =
      zio.aws.ec2.model.ConnectionNotification(
        connectionNotificationId.map(value => value),
        serviceId.map(value => value),
        vpcEndpointId.map(value => value),
        connectionNotificationType.map(value => value),
        connectionNotificationArn.map(value => value),
        connectionEvents.map(value => value),
        connectionNotificationState.map(value => value)
      )
    def connectionNotificationId: Option[String]
    def serviceId: Option[String]
    def vpcEndpointId: Option[String]
    def connectionNotificationType
        : Option[zio.aws.ec2.model.ConnectionNotificationType]
    def connectionNotificationArn: Option[String]
    def connectionEvents: Option[List[String]]
    def connectionNotificationState
        : Option[zio.aws.ec2.model.ConnectionNotificationState]
    def getConnectionNotificationId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("connectionNotificationId", connectionNotificationId)
    def getServiceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceId", serviceId)
    def getVpcEndpointId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcEndpointId", vpcEndpointId)
    def getConnectionNotificationType
        : ZIO[Any, AwsError, zio.aws.ec2.model.ConnectionNotificationType] =
      AwsError.unwrapOptionField(
        "connectionNotificationType",
        connectionNotificationType
      )
    def getConnectionNotificationArn: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("connectionNotificationArn", connectionNotificationArn)
    def getConnectionEvents: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("connectionEvents", connectionEvents)
    def getConnectionNotificationState
        : ZIO[Any, AwsError, zio.aws.ec2.model.ConnectionNotificationState] =
      AwsError.unwrapOptionField(
        "connectionNotificationState",
        connectionNotificationState
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ConnectionNotification
  ) extends zio.aws.ec2.model.ConnectionNotification.ReadOnly {
    override val connectionNotificationId: Option[String] =
      scala.Option(impl.connectionNotificationId()).map(value => value: String)
    override val serviceId: Option[String] =
      scala.Option(impl.serviceId()).map(value => value: String)
    override val vpcEndpointId: Option[String] =
      scala.Option(impl.vpcEndpointId()).map(value => value: String)
    override val connectionNotificationType
        : Option[zio.aws.ec2.model.ConnectionNotificationType] = scala
      .Option(impl.connectionNotificationType())
      .map(value => zio.aws.ec2.model.ConnectionNotificationType.wrap(value))
    override val connectionNotificationArn: Option[String] =
      scala.Option(impl.connectionNotificationArn()).map(value => value: String)
    override val connectionEvents: Option[List[String]] = scala
      .Option(impl.connectionEvents())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val connectionNotificationState
        : Option[zio.aws.ec2.model.ConnectionNotificationState] = scala
      .Option(impl.connectionNotificationState())
      .map(value => zio.aws.ec2.model.ConnectionNotificationState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ConnectionNotification
  ): zio.aws.ec2.model.ConnectionNotification.ReadOnly = new Wrapper(impl)
}
