package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class VpnConnectionOptions(
    enableAcceleration: Option[Boolean] = None,
    staticRoutesOnly: Option[Boolean] = None,
    localIpv4NetworkCidr: Option[String] = None,
    remoteIpv4NetworkCidr: Option[String] = None,
    localIpv6NetworkCidr: Option[String] = None,
    remoteIpv6NetworkCidr: Option[String] = None,
    tunnelInsideIpVersion: Option[zio.aws.ec2.model.TunnelInsideIpVersion] =
      None,
    tunnelOptions: Option[Iterable[zio.aws.ec2.model.TunnelOption]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.VpnConnectionOptions = {
    import VpnConnectionOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.VpnConnectionOptions
      .builder()
      .optionallyWith(
        enableAcceleration.map(value => value: java.lang.Boolean)
      )(_.enableAcceleration)
      .optionallyWith(staticRoutesOnly.map(value => value: java.lang.Boolean))(
        _.staticRoutesOnly
      )
      .optionallyWith(
        localIpv4NetworkCidr.map(value => value: java.lang.String)
      )(_.localIpv4NetworkCidr)
      .optionallyWith(
        remoteIpv4NetworkCidr.map(value => value: java.lang.String)
      )(_.remoteIpv4NetworkCidr)
      .optionallyWith(
        localIpv6NetworkCidr.map(value => value: java.lang.String)
      )(_.localIpv6NetworkCidr)
      .optionallyWith(
        remoteIpv6NetworkCidr.map(value => value: java.lang.String)
      )(_.remoteIpv6NetworkCidr)
      .optionallyWith(tunnelInsideIpVersion.map(value => value.unwrap))(
        _.tunnelInsideIpVersion
      )
      .optionallyWith(
        tunnelOptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tunnelOptions)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.VpnConnectionOptions.ReadOnly =
    zio.aws.ec2.model.VpnConnectionOptions.wrap(buildAwsValue())
}
object VpnConnectionOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.VpnConnectionOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.VpnConnectionOptions =
      zio.aws.ec2.model.VpnConnectionOptions(
        enableAcceleration.map(value => value),
        staticRoutesOnly.map(value => value),
        localIpv4NetworkCidr.map(value => value),
        remoteIpv4NetworkCidr.map(value => value),
        localIpv6NetworkCidr.map(value => value),
        remoteIpv6NetworkCidr.map(value => value),
        tunnelInsideIpVersion.map(value => value),
        tunnelOptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def enableAcceleration: Option[Boolean]
    def staticRoutesOnly: Option[Boolean]
    def localIpv4NetworkCidr: Option[String]
    def remoteIpv4NetworkCidr: Option[String]
    def localIpv6NetworkCidr: Option[String]
    def remoteIpv6NetworkCidr: Option[String]
    def tunnelInsideIpVersion: Option[zio.aws.ec2.model.TunnelInsideIpVersion]
    def tunnelOptions: Option[List[zio.aws.ec2.model.TunnelOption.ReadOnly]]
    def getEnableAcceleration: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enableAcceleration", enableAcceleration)
    def getStaticRoutesOnly: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("staticRoutesOnly", staticRoutesOnly)
    def getLocalIpv4NetworkCidr: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("localIpv4NetworkCidr", localIpv4NetworkCidr)
    def getRemoteIpv4NetworkCidr: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("remoteIpv4NetworkCidr", remoteIpv4NetworkCidr)
    def getLocalIpv6NetworkCidr: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("localIpv6NetworkCidr", localIpv6NetworkCidr)
    def getRemoteIpv6NetworkCidr: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("remoteIpv6NetworkCidr", remoteIpv6NetworkCidr)
    def getTunnelInsideIpVersion
        : ZIO[Any, AwsError, zio.aws.ec2.model.TunnelInsideIpVersion] =
      AwsError.unwrapOptionField("tunnelInsideIpVersion", tunnelInsideIpVersion)
    def getTunnelOptions
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.TunnelOption.ReadOnly]] =
      AwsError.unwrapOptionField("tunnelOptions", tunnelOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.VpnConnectionOptions
  ) extends zio.aws.ec2.model.VpnConnectionOptions.ReadOnly {
    override val enableAcceleration: Option[Boolean] =
      scala.Option(impl.enableAcceleration()).map(value => value: Boolean)
    override val staticRoutesOnly: Option[Boolean] =
      scala.Option(impl.staticRoutesOnly()).map(value => value: Boolean)
    override val localIpv4NetworkCidr: Option[String] =
      scala.Option(impl.localIpv4NetworkCidr()).map(value => value: String)
    override val remoteIpv4NetworkCidr: Option[String] =
      scala.Option(impl.remoteIpv4NetworkCidr()).map(value => value: String)
    override val localIpv6NetworkCidr: Option[String] =
      scala.Option(impl.localIpv6NetworkCidr()).map(value => value: String)
    override val remoteIpv6NetworkCidr: Option[String] =
      scala.Option(impl.remoteIpv6NetworkCidr()).map(value => value: String)
    override val tunnelInsideIpVersion
        : Option[zio.aws.ec2.model.TunnelInsideIpVersion] = scala
      .Option(impl.tunnelInsideIpVersion())
      .map(value => zio.aws.ec2.model.TunnelInsideIpVersion.wrap(value))
    override val tunnelOptions
        : Option[List[zio.aws.ec2.model.TunnelOption.ReadOnly]] = scala
      .Option(impl.tunnelOptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.TunnelOption.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.VpnConnectionOptions
  ): zio.aws.ec2.model.VpnConnectionOptions.ReadOnly = new Wrapper(impl)
}
