package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.PlacementGroupName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ScheduledInstancesPlacement(
    availabilityZone: Option[String] = None,
    groupName: Option[PlacementGroupName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ScheduledInstancesPlacement = {
    import ScheduledInstancesPlacement.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ScheduledInstancesPlacement
      .builder()
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(
        groupName.map(value =>
          PlacementGroupName.unwrap(value): java.lang.String
        )
      )(_.groupName)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ScheduledInstancesPlacement.ReadOnly =
    zio.aws.ec2.model.ScheduledInstancesPlacement.wrap(buildAwsValue())
}
object ScheduledInstancesPlacement {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ScheduledInstancesPlacement
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ScheduledInstancesPlacement =
      zio.aws.ec2.model.ScheduledInstancesPlacement(
        availabilityZone.map(value => value),
        groupName.map(value => value)
      )
    def availabilityZone: Option[String]
    def groupName: Option[PlacementGroupName]
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getGroupName: ZIO[Any, AwsError, PlacementGroupName] =
      AwsError.unwrapOptionField("groupName", groupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ScheduledInstancesPlacement
  ) extends zio.aws.ec2.model.ScheduledInstancesPlacement.ReadOnly {
    override val availabilityZone: Option[String] =
      scala.Option(impl.availabilityZone()).map(value => value: String)
    override val groupName: Option[PlacementGroupName] = scala
      .Option(impl.groupName())
      .map(value => zio.aws.ec2.model.primitives.PlacementGroupName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ScheduledInstancesPlacement
  ): zio.aws.ec2.model.ScheduledInstancesPlacement.ReadOnly = new Wrapper(impl)
}
