package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PurchaseScheduledInstancesRequest(
    clientToken: Option[String] = None,
    purchaseRequests: Iterable[zio.aws.ec2.model.PurchaseRequest]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.PurchaseScheduledInstancesRequest = {
    import PurchaseScheduledInstancesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.PurchaseScheduledInstancesRequest
      .builder()
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .purchaseRequests(purchaseRequests.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.PurchaseScheduledInstancesRequest.ReadOnly =
    zio.aws.ec2.model.PurchaseScheduledInstancesRequest.wrap(buildAwsValue())
}
object PurchaseScheduledInstancesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.PurchaseScheduledInstancesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.PurchaseScheduledInstancesRequest =
      zio.aws.ec2.model.PurchaseScheduledInstancesRequest(
        clientToken.map(value => value),
        purchaseRequests.map { item =>
          item.asEditable
        }
      )
    def clientToken: Option[String]
    def purchaseRequests: List[zio.aws.ec2.model.PurchaseRequest.ReadOnly]
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getPurchaseRequests
        : ZIO[Any, Nothing, List[zio.aws.ec2.model.PurchaseRequest.ReadOnly]] =
      ZIO.succeed(purchaseRequests)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.PurchaseScheduledInstancesRequest
  ) extends zio.aws.ec2.model.PurchaseScheduledInstancesRequest.ReadOnly {
    override val clientToken: Option[String] =
      scala.Option(impl.clientToken()).map(value => value: String)
    override val purchaseRequests
        : List[zio.aws.ec2.model.PurchaseRequest.ReadOnly] = impl
      .purchaseRequests()
      .asScala
      .map { item =>
        zio.aws.ec2.model.PurchaseRequest.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.PurchaseScheduledInstancesRequest
  ): zio.aws.ec2.model.PurchaseScheduledInstancesRequest.ReadOnly = new Wrapper(
    impl
  )
}
