package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PublicIpv4PoolRange(
    firstAddress: Option[String] = None,
    lastAddress: Option[String] = None,
    addressCount: Option[Integer] = None,
    availableAddressCount: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.PublicIpv4PoolRange = {
    import PublicIpv4PoolRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.PublicIpv4PoolRange
      .builder()
      .optionallyWith(firstAddress.map(value => value: java.lang.String))(
        _.firstAddress
      )
      .optionallyWith(lastAddress.map(value => value: java.lang.String))(
        _.lastAddress
      )
      .optionallyWith(addressCount.map(value => value: java.lang.Integer))(
        _.addressCount
      )
      .optionallyWith(
        availableAddressCount.map(value => value: java.lang.Integer)
      )(_.availableAddressCount)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.PublicIpv4PoolRange.ReadOnly =
    zio.aws.ec2.model.PublicIpv4PoolRange.wrap(buildAwsValue())
}
object PublicIpv4PoolRange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.PublicIpv4PoolRange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.PublicIpv4PoolRange =
      zio.aws.ec2.model.PublicIpv4PoolRange(
        firstAddress.map(value => value),
        lastAddress.map(value => value),
        addressCount.map(value => value),
        availableAddressCount.map(value => value)
      )
    def firstAddress: Option[String]
    def lastAddress: Option[String]
    def addressCount: Option[Integer]
    def availableAddressCount: Option[Integer]
    def getFirstAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("firstAddress", firstAddress)
    def getLastAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("lastAddress", lastAddress)
    def getAddressCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("addressCount", addressCount)
    def getAvailableAddressCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("availableAddressCount", availableAddressCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.PublicIpv4PoolRange
  ) extends zio.aws.ec2.model.PublicIpv4PoolRange.ReadOnly {
    override val firstAddress: Option[String] =
      scala.Option(impl.firstAddress()).map(value => value: String)
    override val lastAddress: Option[String] =
      scala.Option(impl.lastAddress()).map(value => value: String)
    override val addressCount: Option[Integer] =
      scala.Option(impl.addressCount()).map(value => value: Integer)
    override val availableAddressCount: Option[Integer] =
      scala.Option(impl.availableAddressCount()).map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.PublicIpv4PoolRange
  ): zio.aws.ec2.model.PublicIpv4PoolRange.ReadOnly = new Wrapper(impl)
}
