package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait PrincipalType {
  def unwrap: software.amazon.awssdk.services.ec2.model.PrincipalType
}
object PrincipalType {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.PrincipalType
  ): zio.aws.ec2.model.PrincipalType = value match {
    case software.amazon.awssdk.services.ec2.model.PrincipalType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.PrincipalType.ALL =>
      val r = All
      r
    case software.amazon.awssdk.services.ec2.model.PrincipalType.SERVICE =>
      val r = Service
      r
    case software.amazon.awssdk.services.ec2.model.PrincipalType.ORGANIZATION_UNIT =>
      val r = OrganizationUnit
      r
    case software.amazon.awssdk.services.ec2.model.PrincipalType.ACCOUNT =>
      val r = Account
      r
    case software.amazon.awssdk.services.ec2.model.PrincipalType.USER =>
      val r = User
      r
    case software.amazon.awssdk.services.ec2.model.PrincipalType.ROLE =>
      val r = Role
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.PrincipalType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.PrincipalType =
      software.amazon.awssdk.services.ec2.model.PrincipalType.UNKNOWN_TO_SDK_VERSION
  }
  case object All extends zio.aws.ec2.model.PrincipalType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.PrincipalType =
      software.amazon.awssdk.services.ec2.model.PrincipalType.ALL
  }
  case object Service extends zio.aws.ec2.model.PrincipalType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.PrincipalType =
      software.amazon.awssdk.services.ec2.model.PrincipalType.SERVICE
  }
  case object OrganizationUnit extends zio.aws.ec2.model.PrincipalType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.PrincipalType =
      software.amazon.awssdk.services.ec2.model.PrincipalType.ORGANIZATION_UNIT
  }
  case object Account extends zio.aws.ec2.model.PrincipalType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.PrincipalType =
      software.amazon.awssdk.services.ec2.model.PrincipalType.ACCOUNT
  }
  case object User extends zio.aws.ec2.model.PrincipalType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.PrincipalType =
      software.amazon.awssdk.services.ec2.model.PrincipalType.USER
  }
  case object Role extends zio.aws.ec2.model.PrincipalType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.PrincipalType =
      software.amazon.awssdk.services.ec2.model.PrincipalType.ROLE
  }
}
