package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Phase1DHGroupNumbersListValue(value: Option[Integer] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.Phase1DHGroupNumbersListValue = {
    import Phase1DHGroupNumbersListValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.Phase1DHGroupNumbersListValue
      .builder()
      .optionallyWith(value.map(value => value: java.lang.Integer))(_.value)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.Phase1DHGroupNumbersListValue.ReadOnly =
    zio.aws.ec2.model.Phase1DHGroupNumbersListValue.wrap(buildAwsValue())
}
object Phase1DHGroupNumbersListValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.Phase1DHGroupNumbersListValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.Phase1DHGroupNumbersListValue =
      zio.aws.ec2.model.Phase1DHGroupNumbersListValue(value.map(value => value))
    def value: Option[Integer]
    def getValue: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.Phase1DHGroupNumbersListValue
  ) extends zio.aws.ec2.model.Phase1DHGroupNumbersListValue.ReadOnly {
    override val value: Option[Integer] =
      scala.Option(impl.value()).map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.Phase1DHGroupNumbersListValue
  ): zio.aws.ec2.model.Phase1DHGroupNumbersListValue.ReadOnly = new Wrapper(
    impl
  )
}
