package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class NetworkInterfacePrivateIpAddress(
    association: Option[zio.aws.ec2.model.NetworkInterfaceAssociation] = None,
    primary: Option[Boolean] = None,
    privateDnsName: Option[String] = None,
    privateIpAddress: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.NetworkInterfacePrivateIpAddress = {
    import NetworkInterfacePrivateIpAddress.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.NetworkInterfacePrivateIpAddress
      .builder()
      .optionallyWith(association.map(value => value.buildAwsValue()))(
        _.association
      )
      .optionallyWith(primary.map(value => value: java.lang.Boolean))(_.primary)
      .optionallyWith(privateDnsName.map(value => value: java.lang.String))(
        _.privateDnsName
      )
      .optionallyWith(privateIpAddress.map(value => value: java.lang.String))(
        _.privateIpAddress
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.NetworkInterfacePrivateIpAddress.ReadOnly =
    zio.aws.ec2.model.NetworkInterfacePrivateIpAddress.wrap(buildAwsValue())
}
object NetworkInterfacePrivateIpAddress {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.NetworkInterfacePrivateIpAddress
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.NetworkInterfacePrivateIpAddress =
      zio.aws.ec2.model.NetworkInterfacePrivateIpAddress(
        association.map(value => value.asEditable),
        primary.map(value => value),
        privateDnsName.map(value => value),
        privateIpAddress.map(value => value)
      )
    def association
        : Option[zio.aws.ec2.model.NetworkInterfaceAssociation.ReadOnly]
    def primary: Option[Boolean]
    def privateDnsName: Option[String]
    def privateIpAddress: Option[String]
    def getAssociation: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.NetworkInterfaceAssociation.ReadOnly
    ] = AwsError.unwrapOptionField("association", association)
    def getPrimary: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("primary", primary)
    def getPrivateDnsName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("privateDnsName", privateDnsName)
    def getPrivateIpAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("privateIpAddress", privateIpAddress)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.NetworkInterfacePrivateIpAddress
  ) extends zio.aws.ec2.model.NetworkInterfacePrivateIpAddress.ReadOnly {
    override val association
        : Option[zio.aws.ec2.model.NetworkInterfaceAssociation.ReadOnly] = scala
      .Option(impl.association())
      .map(value => zio.aws.ec2.model.NetworkInterfaceAssociation.wrap(value))
    override val primary: Option[Boolean] =
      scala.Option(impl.primary()).map(value => value: Boolean)
    override val privateDnsName: Option[String] =
      scala.Option(impl.privateDnsName()).map(value => value: String)
    override val privateIpAddress: Option[String] =
      scala.Option(impl.privateIpAddress()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.NetworkInterfacePrivateIpAddress
  ): zio.aws.ec2.model.NetworkInterfacePrivateIpAddress.ReadOnly = new Wrapper(
    impl
  )
}
