package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.ReservationId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyReservedInstancesRequest(
    reservedInstancesIds: Iterable[ReservationId],
    clientToken: Option[String] = None,
    targetConfigurations: Iterable[
      zio.aws.ec2.model.ReservedInstancesConfiguration
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyReservedInstancesRequest = {
    import ModifyReservedInstancesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyReservedInstancesRequest
      .builder()
      .reservedInstancesIds(reservedInstancesIds.map { item =>
        ReservationId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .targetConfigurations(targetConfigurations.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifyReservedInstancesRequest.ReadOnly =
    zio.aws.ec2.model.ModifyReservedInstancesRequest.wrap(buildAwsValue())
}
object ModifyReservedInstancesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyReservedInstancesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyReservedInstancesRequest =
      zio.aws.ec2.model.ModifyReservedInstancesRequest(
        reservedInstancesIds,
        clientToken.map(value => value),
        targetConfigurations.map { item =>
          item.asEditable
        }
      )
    def reservedInstancesIds: List[ReservationId]
    def clientToken: Option[String]
    def targetConfigurations
        : List[zio.aws.ec2.model.ReservedInstancesConfiguration.ReadOnly]
    def getReservedInstancesIds: ZIO[Any, Nothing, List[ReservationId]] =
      ZIO.succeed(reservedInstancesIds)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getTargetConfigurations: ZIO[Any, Nothing, List[
      zio.aws.ec2.model.ReservedInstancesConfiguration.ReadOnly
    ]] = ZIO.succeed(targetConfigurations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyReservedInstancesRequest
  ) extends zio.aws.ec2.model.ModifyReservedInstancesRequest.ReadOnly {
    override val reservedInstancesIds: List[ReservationId] = impl
      .reservedInstancesIds()
      .asScala
      .map { item =>
        zio.aws.ec2.model.primitives.ReservationId(item)
      }
      .toList
    override val clientToken: Option[String] =
      scala.Option(impl.clientToken()).map(value => value: String)
    override val targetConfigurations
        : List[zio.aws.ec2.model.ReservedInstancesConfiguration.ReadOnly] = impl
      .targetConfigurations()
      .asScala
      .map { item =>
        zio.aws.ec2.model.ReservedInstancesConfiguration.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyReservedInstancesRequest
  ): zio.aws.ec2.model.ModifyReservedInstancesRequest.ReadOnly = new Wrapper(
    impl
  )
}
