package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LaunchTemplatesMonitoringRequest(
    enabled: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.LaunchTemplatesMonitoringRequest = {
    import LaunchTemplatesMonitoringRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.LaunchTemplatesMonitoringRequest
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.LaunchTemplatesMonitoringRequest.ReadOnly =
    zio.aws.ec2.model.LaunchTemplatesMonitoringRequest.wrap(buildAwsValue())
}
object LaunchTemplatesMonitoringRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.LaunchTemplatesMonitoringRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.LaunchTemplatesMonitoringRequest =
      zio.aws.ec2.model
        .LaunchTemplatesMonitoringRequest(enabled.map(value => value))
    def enabled: Option[Boolean]
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.LaunchTemplatesMonitoringRequest
  ) extends zio.aws.ec2.model.LaunchTemplatesMonitoringRequest.ReadOnly {
    override val enabled: Option[Boolean] =
      scala.Option(impl.enabled()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.LaunchTemplatesMonitoringRequest
  ): zio.aws.ec2.model.LaunchTemplatesMonitoringRequest.ReadOnly = new Wrapper(
    impl
  )
}
