package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LaunchTemplateHibernationOptionsRequest(
    configured: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.LaunchTemplateHibernationOptionsRequest = {
    import LaunchTemplateHibernationOptionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.LaunchTemplateHibernationOptionsRequest
      .builder()
      .optionallyWith(configured.map(value => value: java.lang.Boolean))(
        _.configured
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.LaunchTemplateHibernationOptionsRequest.ReadOnly =
    zio.aws.ec2.model.LaunchTemplateHibernationOptionsRequest
      .wrap(buildAwsValue())
}
object LaunchTemplateHibernationOptionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.LaunchTemplateHibernationOptionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.LaunchTemplateHibernationOptionsRequest =
      zio.aws.ec2.model
        .LaunchTemplateHibernationOptionsRequest(configured.map(value => value))
    def configured: Option[Boolean]
    def getConfigured: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("configured", configured)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.LaunchTemplateHibernationOptionsRequest
  ) extends zio.aws.ec2.model.LaunchTemplateHibernationOptionsRequest.ReadOnly {
    override val configured: Option[Boolean] =
      scala.Option(impl.configured()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.LaunchTemplateHibernationOptionsRequest
  ): zio.aws.ec2.model.LaunchTemplateHibernationOptionsRequest.ReadOnly =
    new Wrapper(impl)
}
