package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{KmsKeyId, ImportImageTaskId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ImportImageResponse(
    architecture: Option[String] = None,
    description: Option[String] = None,
    encrypted: Option[Boolean] = None,
    hypervisor: Option[String] = None,
    imageId: Option[String] = None,
    importTaskId: Option[ImportImageTaskId] = None,
    kmsKeyId: Option[KmsKeyId] = None,
    licenseType: Option[String] = None,
    platform: Option[String] = None,
    progress: Option[String] = None,
    snapshotDetails: Option[Iterable[zio.aws.ec2.model.SnapshotDetail]] = None,
    status: Option[String] = None,
    statusMessage: Option[String] = None,
    licenseSpecifications: Option[
      Iterable[zio.aws.ec2.model.ImportImageLicenseConfigurationResponse]
    ] = None,
    tags: Option[Iterable[zio.aws.ec2.model.Tag]] = None,
    usageOperation: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ImportImageResponse = {
    import ImportImageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ImportImageResponse
      .builder()
      .optionallyWith(architecture.map(value => value: java.lang.String))(
        _.architecture
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(encrypted.map(value => value: java.lang.Boolean))(
        _.encrypted
      )
      .optionallyWith(hypervisor.map(value => value: java.lang.String))(
        _.hypervisor
      )
      .optionallyWith(imageId.map(value => value: java.lang.String))(_.imageId)
      .optionallyWith(
        importTaskId.map(value =>
          ImportImageTaskId.unwrap(value): java.lang.String
        )
      )(_.importTaskId)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(licenseType.map(value => value: java.lang.String))(
        _.licenseType
      )
      .optionallyWith(platform.map(value => value: java.lang.String))(
        _.platform
      )
      .optionallyWith(progress.map(value => value: java.lang.String))(
        _.progress
      )
      .optionallyWith(
        snapshotDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.snapshotDetails)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .optionallyWith(
        licenseSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.licenseSpecifications)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(usageOperation.map(value => value: java.lang.String))(
        _.usageOperation
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ImportImageResponse.ReadOnly =
    zio.aws.ec2.model.ImportImageResponse.wrap(buildAwsValue())
}
object ImportImageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ImportImageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ImportImageResponse =
      zio.aws.ec2.model.ImportImageResponse(
        architecture.map(value => value),
        description.map(value => value),
        encrypted.map(value => value),
        hypervisor.map(value => value),
        imageId.map(value => value),
        importTaskId.map(value => value),
        kmsKeyId.map(value => value),
        licenseType.map(value => value),
        platform.map(value => value),
        progress.map(value => value),
        snapshotDetails.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        status.map(value => value),
        statusMessage.map(value => value),
        licenseSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        usageOperation.map(value => value)
      )
    def architecture: Option[String]
    def description: Option[String]
    def encrypted: Option[Boolean]
    def hypervisor: Option[String]
    def imageId: Option[String]
    def importTaskId: Option[ImportImageTaskId]
    def kmsKeyId: Option[KmsKeyId]
    def licenseType: Option[String]
    def platform: Option[String]
    def progress: Option[String]
    def snapshotDetails: Option[List[zio.aws.ec2.model.SnapshotDetail.ReadOnly]]
    def status: Option[String]
    def statusMessage: Option[String]
    def licenseSpecifications: Option[
      List[zio.aws.ec2.model.ImportImageLicenseConfigurationResponse.ReadOnly]
    ]
    def tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def usageOperation: Option[String]
    def getArchitecture: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("architecture", architecture)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("encrypted", encrypted)
    def getHypervisor: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("hypervisor", hypervisor)
    def getImageId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("imageId", imageId)
    def getImportTaskId: ZIO[Any, AwsError, ImportImageTaskId] =
      AwsError.unwrapOptionField("importTaskId", importTaskId)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getLicenseType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("licenseType", licenseType)
    def getPlatform: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("platform", platform)
    def getProgress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("progress", progress)
    def getSnapshotDetails
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.SnapshotDetail.ReadOnly]] =
      AwsError.unwrapOptionField("snapshotDetails", snapshotDetails)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getLicenseSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.ImportImageLicenseConfigurationResponse.ReadOnly
    ]] =
      AwsError.unwrapOptionField("licenseSpecifications", licenseSpecifications)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getUsageOperation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("usageOperation", usageOperation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ImportImageResponse
  ) extends zio.aws.ec2.model.ImportImageResponse.ReadOnly {
    override val architecture: Option[String] =
      scala.Option(impl.architecture()).map(value => value: String)
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val encrypted: Option[Boolean] =
      scala.Option(impl.encrypted()).map(value => value: Boolean)
    override val hypervisor: Option[String] =
      scala.Option(impl.hypervisor()).map(value => value: String)
    override val imageId: Option[String] =
      scala.Option(impl.imageId()).map(value => value: String)
    override val importTaskId: Option[ImportImageTaskId] = scala
      .Option(impl.importTaskId())
      .map(value => zio.aws.ec2.model.primitives.ImportImageTaskId(value))
    override val kmsKeyId: Option[KmsKeyId] = scala
      .Option(impl.kmsKeyId())
      .map(value => zio.aws.ec2.model.primitives.KmsKeyId(value))
    override val licenseType: Option[String] =
      scala.Option(impl.licenseType()).map(value => value: String)
    override val platform: Option[String] =
      scala.Option(impl.platform()).map(value => value: String)
    override val progress: Option[String] =
      scala.Option(impl.progress()).map(value => value: String)
    override val snapshotDetails
        : Option[List[zio.aws.ec2.model.SnapshotDetail.ReadOnly]] = scala
      .Option(impl.snapshotDetails())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.SnapshotDetail.wrap(item)
        }.toList
      )
    override val status: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override val statusMessage: Option[String] =
      scala.Option(impl.statusMessage()).map(value => value: String)
    override val licenseSpecifications: Option[
      List[zio.aws.ec2.model.ImportImageLicenseConfigurationResponse.ReadOnly]
    ] = scala
      .Option(impl.licenseSpecifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.ImportImageLicenseConfigurationResponse.wrap(item)
        }.toList
      )
    override val tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Tag.wrap(item)
        }.toList
      )
    override val usageOperation: Option[String] =
      scala.Option(impl.usageOperation()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ImportImageResponse
  ): zio.aws.ec2.model.ImportImageResponse.ReadOnly = new Wrapper(impl)
}
