package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Image(
    architecture: Option[zio.aws.ec2.model.ArchitectureValues] = None,
    creationDate: Option[String] = None,
    imageId: Option[String] = None,
    imageLocation: Option[String] = None,
    imageType: Option[zio.aws.ec2.model.ImageTypeValues] = None,
    publicLaunchPermissions: Option[Boolean] = None,
    kernelId: Option[String] = None,
    ownerId: Option[String] = None,
    platform: Option[zio.aws.ec2.model.PlatformValues] = None,
    platformDetails: Option[String] = None,
    usageOperation: Option[String] = None,
    productCodes: Option[Iterable[zio.aws.ec2.model.ProductCode]] = None,
    ramdiskId: Option[String] = None,
    state: Option[zio.aws.ec2.model.ImageState] = None,
    blockDeviceMappings: Option[
      Iterable[zio.aws.ec2.model.BlockDeviceMapping]
    ] = None,
    description: Option[String] = None,
    enaSupport: Option[Boolean] = None,
    hypervisor: Option[zio.aws.ec2.model.HypervisorType] = None,
    imageOwnerAlias: Option[String] = None,
    name: Option[String] = None,
    rootDeviceName: Option[String] = None,
    rootDeviceType: Option[zio.aws.ec2.model.DeviceType] = None,
    sriovNetSupport: Option[String] = None,
    stateReason: Option[zio.aws.ec2.model.StateReason] = None,
    tags: Option[Iterable[zio.aws.ec2.model.Tag]] = None,
    virtualizationType: Option[zio.aws.ec2.model.VirtualizationType] = None,
    bootMode: Option[zio.aws.ec2.model.BootModeValues] = None,
    deprecationTime: Option[String] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.Image = {
    import Image.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.Image
      .builder()
      .optionallyWith(architecture.map(value => value.unwrap))(_.architecture)
      .optionallyWith(creationDate.map(value => value: java.lang.String))(
        _.creationDate
      )
      .optionallyWith(imageId.map(value => value: java.lang.String))(_.imageId)
      .optionallyWith(imageLocation.map(value => value: java.lang.String))(
        _.imageLocation
      )
      .optionallyWith(imageType.map(value => value.unwrap))(_.imageType)
      .optionallyWith(
        publicLaunchPermissions.map(value => value: java.lang.Boolean)
      )(_.publicLaunchPermissions)
      .optionallyWith(kernelId.map(value => value: java.lang.String))(
        _.kernelId
      )
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .optionallyWith(platform.map(value => value.unwrap))(_.platform)
      .optionallyWith(platformDetails.map(value => value: java.lang.String))(
        _.platformDetails
      )
      .optionallyWith(usageOperation.map(value => value: java.lang.String))(
        _.usageOperation
      )
      .optionallyWith(
        productCodes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.productCodes)
      .optionallyWith(ramdiskId.map(value => value: java.lang.String))(
        _.ramdiskId
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        blockDeviceMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.blockDeviceMappings)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(enaSupport.map(value => value: java.lang.Boolean))(
        _.enaSupport
      )
      .optionallyWith(hypervisor.map(value => value.unwrap))(_.hypervisor)
      .optionallyWith(imageOwnerAlias.map(value => value: java.lang.String))(
        _.imageOwnerAlias
      )
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(rootDeviceName.map(value => value: java.lang.String))(
        _.rootDeviceName
      )
      .optionallyWith(rootDeviceType.map(value => value.unwrap))(
        _.rootDeviceType
      )
      .optionallyWith(sriovNetSupport.map(value => value: java.lang.String))(
        _.sriovNetSupport
      )
      .optionallyWith(stateReason.map(value => value.buildAwsValue()))(
        _.stateReason
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(virtualizationType.map(value => value.unwrap))(
        _.virtualizationType
      )
      .optionallyWith(bootMode.map(value => value.unwrap))(_.bootMode)
      .optionallyWith(deprecationTime.map(value => value: java.lang.String))(
        _.deprecationTime
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.Image.ReadOnly =
    zio.aws.ec2.model.Image.wrap(buildAwsValue())
}
object Image {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.Image] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.Image = zio.aws.ec2.model.Image(
      architecture.map(value => value),
      creationDate.map(value => value),
      imageId.map(value => value),
      imageLocation.map(value => value),
      imageType.map(value => value),
      publicLaunchPermissions.map(value => value),
      kernelId.map(value => value),
      ownerId.map(value => value),
      platform.map(value => value),
      platformDetails.map(value => value),
      usageOperation.map(value => value),
      productCodes.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      ramdiskId.map(value => value),
      state.map(value => value),
      blockDeviceMappings.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      description.map(value => value),
      enaSupport.map(value => value),
      hypervisor.map(value => value),
      imageOwnerAlias.map(value => value),
      name.map(value => value),
      rootDeviceName.map(value => value),
      rootDeviceType.map(value => value),
      sriovNetSupport.map(value => value),
      stateReason.map(value => value.asEditable),
      tags.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      virtualizationType.map(value => value),
      bootMode.map(value => value),
      deprecationTime.map(value => value)
    )
    def architecture: Option[zio.aws.ec2.model.ArchitectureValues]
    def creationDate: Option[String]
    def imageId: Option[String]
    def imageLocation: Option[String]
    def imageType: Option[zio.aws.ec2.model.ImageTypeValues]
    def publicLaunchPermissions: Option[Boolean]
    def kernelId: Option[String]
    def ownerId: Option[String]
    def platform: Option[zio.aws.ec2.model.PlatformValues]
    def platformDetails: Option[String]
    def usageOperation: Option[String]
    def productCodes: Option[List[zio.aws.ec2.model.ProductCode.ReadOnly]]
    def ramdiskId: Option[String]
    def state: Option[zio.aws.ec2.model.ImageState]
    def blockDeviceMappings
        : Option[List[zio.aws.ec2.model.BlockDeviceMapping.ReadOnly]]
    def description: Option[String]
    def enaSupport: Option[Boolean]
    def hypervisor: Option[zio.aws.ec2.model.HypervisorType]
    def imageOwnerAlias: Option[String]
    def name: Option[String]
    def rootDeviceName: Option[String]
    def rootDeviceType: Option[zio.aws.ec2.model.DeviceType]
    def sriovNetSupport: Option[String]
    def stateReason: Option[zio.aws.ec2.model.StateReason.ReadOnly]
    def tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def virtualizationType: Option[zio.aws.ec2.model.VirtualizationType]
    def bootMode: Option[zio.aws.ec2.model.BootModeValues]
    def deprecationTime: Option[String]
    def getArchitecture
        : ZIO[Any, AwsError, zio.aws.ec2.model.ArchitectureValues] =
      AwsError.unwrapOptionField("architecture", architecture)
    def getCreationDate: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getImageId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("imageId", imageId)
    def getImageLocation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("imageLocation", imageLocation)
    def getImageType: ZIO[Any, AwsError, zio.aws.ec2.model.ImageTypeValues] =
      AwsError.unwrapOptionField("imageType", imageType)
    def getPublicLaunchPermissions: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("publicLaunchPermissions", publicLaunchPermissions)
    def getKernelId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kernelId", kernelId)
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getPlatform: ZIO[Any, AwsError, zio.aws.ec2.model.PlatformValues] =
      AwsError.unwrapOptionField("platform", platform)
    def getPlatformDetails: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("platformDetails", platformDetails)
    def getUsageOperation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("usageOperation", usageOperation)
    def getProductCodes
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.ProductCode.ReadOnly]] =
      AwsError.unwrapOptionField("productCodes", productCodes)
    def getRamdiskId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ramdiskId", ramdiskId)
    def getState: ZIO[Any, AwsError, zio.aws.ec2.model.ImageState] =
      AwsError.unwrapOptionField("state", state)
    def getBlockDeviceMappings: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.BlockDeviceMapping.ReadOnly
    ]] = AwsError.unwrapOptionField("blockDeviceMappings", blockDeviceMappings)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getEnaSupport: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enaSupport", enaSupport)
    def getHypervisor: ZIO[Any, AwsError, zio.aws.ec2.model.HypervisorType] =
      AwsError.unwrapOptionField("hypervisor", hypervisor)
    def getImageOwnerAlias: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("imageOwnerAlias", imageOwnerAlias)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getRootDeviceName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("rootDeviceName", rootDeviceName)
    def getRootDeviceType: ZIO[Any, AwsError, zio.aws.ec2.model.DeviceType] =
      AwsError.unwrapOptionField("rootDeviceType", rootDeviceType)
    def getSriovNetSupport: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sriovNetSupport", sriovNetSupport)
    def getStateReason
        : ZIO[Any, AwsError, zio.aws.ec2.model.StateReason.ReadOnly] =
      AwsError.unwrapOptionField("stateReason", stateReason)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getVirtualizationType
        : ZIO[Any, AwsError, zio.aws.ec2.model.VirtualizationType] =
      AwsError.unwrapOptionField("virtualizationType", virtualizationType)
    def getBootMode: ZIO[Any, AwsError, zio.aws.ec2.model.BootModeValues] =
      AwsError.unwrapOptionField("bootMode", bootMode)
    def getDeprecationTime: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("deprecationTime", deprecationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.Image
  ) extends zio.aws.ec2.model.Image.ReadOnly {
    override val architecture: Option[zio.aws.ec2.model.ArchitectureValues] =
      scala
        .Option(impl.architecture())
        .map(value => zio.aws.ec2.model.ArchitectureValues.wrap(value))
    override val creationDate: Option[String] =
      scala.Option(impl.creationDate()).map(value => value: String)
    override val imageId: Option[String] =
      scala.Option(impl.imageId()).map(value => value: String)
    override val imageLocation: Option[String] =
      scala.Option(impl.imageLocation()).map(value => value: String)
    override val imageType: Option[zio.aws.ec2.model.ImageTypeValues] = scala
      .Option(impl.imageType())
      .map(value => zio.aws.ec2.model.ImageTypeValues.wrap(value))
    override val publicLaunchPermissions: Option[Boolean] =
      scala.Option(impl.publicLaunchPermissions()).map(value => value: Boolean)
    override val kernelId: Option[String] =
      scala.Option(impl.kernelId()).map(value => value: String)
    override val ownerId: Option[String] =
      scala.Option(impl.ownerId()).map(value => value: String)
    override val platform: Option[zio.aws.ec2.model.PlatformValues] = scala
      .Option(impl.platform())
      .map(value => zio.aws.ec2.model.PlatformValues.wrap(value))
    override val platformDetails: Option[String] =
      scala.Option(impl.platformDetails()).map(value => value: String)
    override val usageOperation: Option[String] =
      scala.Option(impl.usageOperation()).map(value => value: String)
    override val productCodes
        : Option[List[zio.aws.ec2.model.ProductCode.ReadOnly]] = scala
      .Option(impl.productCodes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.ProductCode.wrap(item)
        }.toList
      )
    override val ramdiskId: Option[String] =
      scala.Option(impl.ramdiskId()).map(value => value: String)
    override val state: Option[zio.aws.ec2.model.ImageState] = scala
      .Option(impl.state())
      .map(value => zio.aws.ec2.model.ImageState.wrap(value))
    override val blockDeviceMappings
        : Option[List[zio.aws.ec2.model.BlockDeviceMapping.ReadOnly]] = scala
      .Option(impl.blockDeviceMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.BlockDeviceMapping.wrap(item)
        }.toList
      )
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val enaSupport: Option[Boolean] =
      scala.Option(impl.enaSupport()).map(value => value: Boolean)
    override val hypervisor: Option[zio.aws.ec2.model.HypervisorType] = scala
      .Option(impl.hypervisor())
      .map(value => zio.aws.ec2.model.HypervisorType.wrap(value))
    override val imageOwnerAlias: Option[String] =
      scala.Option(impl.imageOwnerAlias()).map(value => value: String)
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val rootDeviceName: Option[String] =
      scala.Option(impl.rootDeviceName()).map(value => value: String)
    override val rootDeviceType: Option[zio.aws.ec2.model.DeviceType] = scala
      .Option(impl.rootDeviceType())
      .map(value => zio.aws.ec2.model.DeviceType.wrap(value))
    override val sriovNetSupport: Option[String] =
      scala.Option(impl.sriovNetSupport()).map(value => value: String)
    override val stateReason: Option[zio.aws.ec2.model.StateReason.ReadOnly] =
      scala
        .Option(impl.stateReason())
        .map(value => zio.aws.ec2.model.StateReason.wrap(value))
    override val tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Tag.wrap(item)
        }.toList
      )
    override val virtualizationType
        : Option[zio.aws.ec2.model.VirtualizationType] = scala
      .Option(impl.virtualizationType())
      .map(value => zio.aws.ec2.model.VirtualizationType.wrap(value))
    override val bootMode: Option[zio.aws.ec2.model.BootModeValues] = scala
      .Option(impl.bootMode())
      .map(value => zio.aws.ec2.model.BootModeValues.wrap(value))
    override val deprecationTime: Option[String] =
      scala.Option(impl.deprecationTime()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.Image
  ): zio.aws.ec2.model.Image.ReadOnly = new Wrapper(impl)
}
