package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait FlowLogsResourceType {
  def unwrap: software.amazon.awssdk.services.ec2.model.FlowLogsResourceType
}
object FlowLogsResourceType {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.FlowLogsResourceType
  ): zio.aws.ec2.model.FlowLogsResourceType = value match {
    case software.amazon.awssdk.services.ec2.model.FlowLogsResourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.FlowLogsResourceType.VPC =>
      val r = VPC
      r
    case software.amazon.awssdk.services.ec2.model.FlowLogsResourceType.SUBNET =>
      val r = Subnet
      r
    case software.amazon.awssdk.services.ec2.model.FlowLogsResourceType.NETWORK_INTERFACE =>
      val r = NetworkInterface
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.FlowLogsResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.FlowLogsResourceType =
      software.amazon.awssdk.services.ec2.model.FlowLogsResourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object VPC extends zio.aws.ec2.model.FlowLogsResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.FlowLogsResourceType =
      software.amazon.awssdk.services.ec2.model.FlowLogsResourceType.VPC
  }
  case object Subnet extends zio.aws.ec2.model.FlowLogsResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.FlowLogsResourceType =
      software.amazon.awssdk.services.ec2.model.FlowLogsResourceType.SUBNET
  }
  case object NetworkInterface extends zio.aws.ec2.model.FlowLogsResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.FlowLogsResourceType =
      software.amazon.awssdk.services.ec2.model.FlowLogsResourceType.NETWORK_INTERFACE
  }
}
