package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{Integer, VpcEndpointId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeVpcEndpointsRequest(
    vpcEndpointIds: Option[Iterable[VpcEndpointId]] = None,
    filters: Option[Iterable[zio.aws.ec2.model.Filter]] = None,
    maxResults: Option[Integer] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointsRequest = {
    import DescribeVpcEndpointsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointsRequest
      .builder()
      .optionallyWith(
        vpcEndpointIds.map(value =>
          value.map { item =>
            VpcEndpointId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.vpcEndpointIds)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(maxResults.map(value => value: java.lang.Integer))(
        _.maxResults
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeVpcEndpointsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeVpcEndpointsRequest.wrap(buildAwsValue())
}
object DescribeVpcEndpointsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeVpcEndpointsRequest =
      zio.aws.ec2.model.DescribeVpcEndpointsRequest(
        vpcEndpointIds.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def vpcEndpointIds: Option[List[VpcEndpointId]]
    def filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def maxResults: Option[Integer]
    def nextToken: Option[String]
    def getVpcEndpointIds: ZIO[Any, AwsError, List[VpcEndpointId]] =
      AwsError.unwrapOptionField("vpcEndpointIds", vpcEndpointIds)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointsRequest
  ) extends zio.aws.ec2.model.DescribeVpcEndpointsRequest.ReadOnly {
    override val vpcEndpointIds: Option[List[VpcEndpointId]] = scala
      .Option(impl.vpcEndpointIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.VpcEndpointId(item)
        }.toList
      )
    override val filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val maxResults: Option[Integer] =
      scala.Option(impl.maxResults()).map(value => value: Integer)
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointsRequest
  ): zio.aws.ec2.model.DescribeVpcEndpointsRequest.ReadOnly = new Wrapper(impl)
}
