package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.{
  SpotFleetRequestId,
  DescribeSpotFleetInstancesMaxResults
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeSpotFleetInstancesRequest(
    maxResults: Option[DescribeSpotFleetInstancesMaxResults] = None,
    nextToken: Option[String] = None,
    spotFleetRequestId: SpotFleetRequestId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeSpotFleetInstancesRequest = {
    import DescribeSpotFleetInstancesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeSpotFleetInstancesRequest
      .builder()
      .optionallyWith(
        maxResults.map(value =>
          DescribeSpotFleetInstancesMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .spotFleetRequestId(
        SpotFleetRequestId.unwrap(spotFleetRequestId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeSpotFleetInstancesRequest.ReadOnly =
    zio.aws.ec2.model.DescribeSpotFleetInstancesRequest.wrap(buildAwsValue())
}
object DescribeSpotFleetInstancesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeSpotFleetInstancesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeSpotFleetInstancesRequest =
      zio.aws.ec2.model.DescribeSpotFleetInstancesRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        spotFleetRequestId
      )
    def maxResults: Option[DescribeSpotFleetInstancesMaxResults]
    def nextToken: Option[String]
    def spotFleetRequestId: SpotFleetRequestId
    def getMaxResults
        : ZIO[Any, AwsError, DescribeSpotFleetInstancesMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSpotFleetRequestId: ZIO[Any, Nothing, SpotFleetRequestId] =
      ZIO.succeed(spotFleetRequestId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeSpotFleetInstancesRequest
  ) extends zio.aws.ec2.model.DescribeSpotFleetInstancesRequest.ReadOnly {
    override val maxResults: Option[DescribeSpotFleetInstancesMaxResults] =
      scala
        .Option(impl.maxResults())
        .map(value =>
          zio.aws.ec2.model.primitives
            .DescribeSpotFleetInstancesMaxResults(value)
        )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val spotFleetRequestId: SpotFleetRequestId =
      zio.aws.ec2.model.primitives.SpotFleetRequestId(impl.spotFleetRequestId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeSpotFleetInstancesRequest
  ): zio.aws.ec2.model.DescribeSpotFleetInstancesRequest.ReadOnly = new Wrapper(
    impl
  )
}
