package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeSnapshotsResponse(
    snapshots: Option[Iterable[zio.aws.ec2.model.Snapshot]] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeSnapshotsResponse = {
    import DescribeSnapshotsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeSnapshotsResponse
      .builder()
      .optionallyWith(
        snapshots.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.snapshots)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeSnapshotsResponse.ReadOnly =
    zio.aws.ec2.model.DescribeSnapshotsResponse.wrap(buildAwsValue())
}
object DescribeSnapshotsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeSnapshotsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeSnapshotsResponse =
      zio.aws.ec2.model.DescribeSnapshotsResponse(
        snapshots.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def snapshots: Option[List[zio.aws.ec2.model.Snapshot.ReadOnly]]
    def nextToken: Option[String]
    def getSnapshots
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Snapshot.ReadOnly]] =
      AwsError.unwrapOptionField("snapshots", snapshots)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeSnapshotsResponse
  ) extends zio.aws.ec2.model.DescribeSnapshotsResponse.ReadOnly {
    override val snapshots: Option[List[zio.aws.ec2.model.Snapshot.ReadOnly]] =
      scala
        .Option(impl.snapshots())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Snapshot.wrap(item)
          }.toList
        )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeSnapshotsResponse
  ): zio.aws.ec2.model.DescribeSnapshotsResponse.ReadOnly = new Wrapper(impl)
}
