package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeImportSnapshotTasksResponse(
    importSnapshotTasks: Option[
      Iterable[zio.aws.ec2.model.ImportSnapshotTask]
    ] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeImportSnapshotTasksResponse = {
    import DescribeImportSnapshotTasksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeImportSnapshotTasksResponse
      .builder()
      .optionallyWith(
        importSnapshotTasks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.importSnapshotTasks)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeImportSnapshotTasksResponse.ReadOnly =
    zio.aws.ec2.model.DescribeImportSnapshotTasksResponse.wrap(buildAwsValue())
}
object DescribeImportSnapshotTasksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeImportSnapshotTasksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeImportSnapshotTasksResponse =
      zio.aws.ec2.model.DescribeImportSnapshotTasksResponse(
        importSnapshotTasks.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def importSnapshotTasks
        : Option[List[zio.aws.ec2.model.ImportSnapshotTask.ReadOnly]]
    def nextToken: Option[String]
    def getImportSnapshotTasks: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.ImportSnapshotTask.ReadOnly
    ]] = AwsError.unwrapOptionField("importSnapshotTasks", importSnapshotTasks)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeImportSnapshotTasksResponse
  ) extends zio.aws.ec2.model.DescribeImportSnapshotTasksResponse.ReadOnly {
    override val importSnapshotTasks
        : Option[List[zio.aws.ec2.model.ImportSnapshotTask.ReadOnly]] = scala
      .Option(impl.importSnapshotTasks())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.ImportSnapshotTask.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeImportSnapshotTasksResponse
  ): zio.aws.ec2.model.DescribeImportSnapshotTasksResponse.ReadOnly =
    new Wrapper(impl)
}
