package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.{
  NextToken,
  DescribeClientVpnRoutesMaxResults,
  ClientVpnEndpointId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeClientVpnRoutesRequest(
    clientVpnEndpointId: ClientVpnEndpointId,
    filters: Option[Iterable[zio.aws.ec2.model.Filter]] = None,
    maxResults: Option[DescribeClientVpnRoutesMaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeClientVpnRoutesRequest = {
    import DescribeClientVpnRoutesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeClientVpnRoutesRequest
      .builder()
      .clientVpnEndpointId(
        ClientVpnEndpointId.unwrap(clientVpnEndpointId): java.lang.String
      )
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value =>
          DescribeClientVpnRoutesMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeClientVpnRoutesRequest.ReadOnly =
    zio.aws.ec2.model.DescribeClientVpnRoutesRequest.wrap(buildAwsValue())
}
object DescribeClientVpnRoutesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeClientVpnRoutesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeClientVpnRoutesRequest =
      zio.aws.ec2.model.DescribeClientVpnRoutesRequest(
        clientVpnEndpointId,
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def clientVpnEndpointId: ClientVpnEndpointId
    def filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def maxResults: Option[DescribeClientVpnRoutesMaxResults]
    def nextToken: Option[NextToken]
    def getClientVpnEndpointId: ZIO[Any, Nothing, ClientVpnEndpointId] =
      ZIO.succeed(clientVpnEndpointId)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, DescribeClientVpnRoutesMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeClientVpnRoutesRequest
  ) extends zio.aws.ec2.model.DescribeClientVpnRoutesRequest.ReadOnly {
    override val clientVpnEndpointId: ClientVpnEndpointId =
      zio.aws.ec2.model.primitives
        .ClientVpnEndpointId(impl.clientVpnEndpointId())
    override val filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val maxResults: Option[DescribeClientVpnRoutesMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.ec2.model.primitives.DescribeClientVpnRoutesMaxResults(value)
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeClientVpnRoutesRequest
  ): zio.aws.ec2.model.DescribeClientVpnRoutesRequest.ReadOnly = new Wrapper(
    impl
  )
}
