package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteIpamPoolResponse(
    ipamPool: Option[zio.aws.ec2.model.IpamPool] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteIpamPoolResponse = {
    import DeleteIpamPoolResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteIpamPoolResponse
      .builder()
      .optionallyWith(ipamPool.map(value => value.buildAwsValue()))(_.ipamPool)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteIpamPoolResponse.ReadOnly =
    zio.aws.ec2.model.DeleteIpamPoolResponse.wrap(buildAwsValue())
}
object DeleteIpamPoolResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteIpamPoolResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteIpamPoolResponse = zio.aws.ec2.model
      .DeleteIpamPoolResponse(ipamPool.map(value => value.asEditable))
    def ipamPool: Option[zio.aws.ec2.model.IpamPool.ReadOnly]
    def getIpamPool: ZIO[Any, AwsError, zio.aws.ec2.model.IpamPool.ReadOnly] =
      AwsError.unwrapOptionField("ipamPool", ipamPool)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteIpamPoolResponse
  ) extends zio.aws.ec2.model.DeleteIpamPoolResponse.ReadOnly {
    override val ipamPool: Option[zio.aws.ec2.model.IpamPool.ReadOnly] = scala
      .Option(impl.ipamPool())
      .map(value => zio.aws.ec2.model.IpamPool.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteIpamPoolResponse
  ): zio.aws.ec2.model.DeleteIpamPoolResponse.ReadOnly = new Wrapper(impl)
}
