package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.EgressOnlyInternetGatewayId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteEgressOnlyInternetGatewayRequest(
    egressOnlyInternetGatewayId: EgressOnlyInternetGatewayId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteEgressOnlyInternetGatewayRequest = {
    import DeleteEgressOnlyInternetGatewayRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteEgressOnlyInternetGatewayRequest
      .builder()
      .egressOnlyInternetGatewayId(
        EgressOnlyInternetGatewayId.unwrap(
          egressOnlyInternetGatewayId
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeleteEgressOnlyInternetGatewayRequest.ReadOnly =
    zio.aws.ec2.model.DeleteEgressOnlyInternetGatewayRequest
      .wrap(buildAwsValue())
}
object DeleteEgressOnlyInternetGatewayRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteEgressOnlyInternetGatewayRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteEgressOnlyInternetGatewayRequest =
      zio.aws.ec2.model
        .DeleteEgressOnlyInternetGatewayRequest(egressOnlyInternetGatewayId)
    def egressOnlyInternetGatewayId: EgressOnlyInternetGatewayId
    def getEgressOnlyInternetGatewayId
        : ZIO[Any, Nothing, EgressOnlyInternetGatewayId] =
      ZIO.succeed(egressOnlyInternetGatewayId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteEgressOnlyInternetGatewayRequest
  ) extends zio.aws.ec2.model.DeleteEgressOnlyInternetGatewayRequest.ReadOnly {
    override val egressOnlyInternetGatewayId: EgressOnlyInternetGatewayId =
      zio.aws.ec2.model.primitives
        .EgressOnlyInternetGatewayId(impl.egressOnlyInternetGatewayId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteEgressOnlyInternetGatewayRequest
  ): zio.aws.ec2.model.DeleteEgressOnlyInternetGatewayRequest.ReadOnly =
    new Wrapper(impl)
}
