package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  SecurityGroupId,
  SubnetId,
  RouteTableId,
  VpcId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateVpcEndpointRequest(
    vpcEndpointType: Option[zio.aws.ec2.model.VpcEndpointType] = None,
    vpcId: VpcId,
    serviceName: String,
    policyDocument: Option[String] = None,
    routeTableIds: Option[Iterable[RouteTableId]] = None,
    subnetIds: Option[Iterable[SubnetId]] = None,
    securityGroupIds: Option[Iterable[SecurityGroupId]] = None,
    clientToken: Option[String] = None,
    privateDnsEnabled: Option[Boolean] = None,
    tagSpecifications: Option[Iterable[zio.aws.ec2.model.TagSpecification]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateVpcEndpointRequest = {
    import CreateVpcEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateVpcEndpointRequest
      .builder()
      .optionallyWith(vpcEndpointType.map(value => value.unwrap))(
        _.vpcEndpointType
      )
      .vpcId(VpcId.unwrap(vpcId): java.lang.String)
      .serviceName(serviceName: java.lang.String)
      .optionallyWith(policyDocument.map(value => value: java.lang.String))(
        _.policyDocument
      )
      .optionallyWith(
        routeTableIds.map(value =>
          value.map { item =>
            RouteTableId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.routeTableIds)
      .optionallyWith(
        subnetIds.map(value =>
          value.map { item =>
            SubnetId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.subnetIds)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(privateDnsEnabled.map(value => value: java.lang.Boolean))(
        _.privateDnsEnabled
      )
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateVpcEndpointRequest.ReadOnly =
    zio.aws.ec2.model.CreateVpcEndpointRequest.wrap(buildAwsValue())
}
object CreateVpcEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateVpcEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateVpcEndpointRequest =
      zio.aws.ec2.model.CreateVpcEndpointRequest(
        vpcEndpointType.map(value => value),
        vpcId,
        serviceName,
        policyDocument.map(value => value),
        routeTableIds.map(value => value),
        subnetIds.map(value => value),
        securityGroupIds.map(value => value),
        clientToken.map(value => value),
        privateDnsEnabled.map(value => value),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def vpcEndpointType: Option[zio.aws.ec2.model.VpcEndpointType]
    def vpcId: VpcId
    def serviceName: String
    def policyDocument: Option[String]
    def routeTableIds: Option[List[RouteTableId]]
    def subnetIds: Option[List[SubnetId]]
    def securityGroupIds: Option[List[SecurityGroupId]]
    def clientToken: Option[String]
    def privateDnsEnabled: Option[Boolean]
    def tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def getVpcEndpointType
        : ZIO[Any, AwsError, zio.aws.ec2.model.VpcEndpointType] =
      AwsError.unwrapOptionField("vpcEndpointType", vpcEndpointType)
    def getVpcId: ZIO[Any, Nothing, VpcId] = ZIO.succeed(vpcId)
    def getServiceName: ZIO[Any, Nothing, String] = ZIO.succeed(serviceName)
    def getPolicyDocument: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("policyDocument", policyDocument)
    def getRouteTableIds: ZIO[Any, AwsError, List[RouteTableId]] =
      AwsError.unwrapOptionField("routeTableIds", routeTableIds)
    def getSubnetIds: ZIO[Any, AwsError, List[SubnetId]] =
      AwsError.unwrapOptionField("subnetIds", subnetIds)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getPrivateDnsEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("privateDnsEnabled", privateDnsEnabled)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateVpcEndpointRequest
  ) extends zio.aws.ec2.model.CreateVpcEndpointRequest.ReadOnly {
    override val vpcEndpointType: Option[zio.aws.ec2.model.VpcEndpointType] =
      scala
        .Option(impl.vpcEndpointType())
        .map(value => zio.aws.ec2.model.VpcEndpointType.wrap(value))
    override val vpcId: VpcId = zio.aws.ec2.model.primitives.VpcId(impl.vpcId())
    override val serviceName: String = impl.serviceName(): String
    override val policyDocument: Option[String] =
      scala.Option(impl.policyDocument()).map(value => value: String)
    override val routeTableIds: Option[List[RouteTableId]] = scala
      .Option(impl.routeTableIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.RouteTableId(item)
        }.toList
      )
    override val subnetIds: Option[List[SubnetId]] = scala
      .Option(impl.subnetIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.SubnetId(item)
        }.toList
      )
    override val securityGroupIds: Option[List[SecurityGroupId]] = scala
      .Option(impl.securityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.SecurityGroupId(item)
        }.toList
      )
    override val clientToken: Option[String] =
      scala.Option(impl.clientToken()).map(value => value: String)
    override val privateDnsEnabled: Option[Boolean] =
      scala.Option(impl.privateDnsEnabled()).map(value => value: Boolean)
    override val tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] = scala
      .Option(impl.tagSpecifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.TagSpecification.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateVpcEndpointRequest
  ): zio.aws.ec2.model.CreateVpcEndpointRequest.ReadOnly = new Wrapper(impl)
}
