package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  LocalGatewayVirtualInterfaceGroupId,
  LocalGatewayRoutetableId
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateLocalGatewayRouteRequest(
    destinationCidrBlock: String,
    localGatewayRouteTableId: LocalGatewayRoutetableId,
    localGatewayVirtualInterfaceGroupId: LocalGatewayVirtualInterfaceGroupId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteRequest = {
    import CreateLocalGatewayRouteRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteRequest
      .builder()
      .destinationCidrBlock(destinationCidrBlock: java.lang.String)
      .localGatewayRouteTableId(
        LocalGatewayRoutetableId.unwrap(
          localGatewayRouteTableId
        ): java.lang.String
      )
      .localGatewayVirtualInterfaceGroupId(
        LocalGatewayVirtualInterfaceGroupId.unwrap(
          localGatewayVirtualInterfaceGroupId
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateLocalGatewayRouteRequest.ReadOnly =
    zio.aws.ec2.model.CreateLocalGatewayRouteRequest.wrap(buildAwsValue())
}
object CreateLocalGatewayRouteRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateLocalGatewayRouteRequest =
      zio.aws.ec2.model.CreateLocalGatewayRouteRequest(
        destinationCidrBlock,
        localGatewayRouteTableId,
        localGatewayVirtualInterfaceGroupId
      )
    def destinationCidrBlock: String
    def localGatewayRouteTableId: LocalGatewayRoutetableId
    def localGatewayVirtualInterfaceGroupId: LocalGatewayVirtualInterfaceGroupId
    def getDestinationCidrBlock: ZIO[Any, Nothing, String] =
      ZIO.succeed(destinationCidrBlock)
    def getLocalGatewayRouteTableId
        : ZIO[Any, Nothing, LocalGatewayRoutetableId] =
      ZIO.succeed(localGatewayRouteTableId)
    def getLocalGatewayVirtualInterfaceGroupId
        : ZIO[Any, Nothing, LocalGatewayVirtualInterfaceGroupId] =
      ZIO.succeed(localGatewayVirtualInterfaceGroupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteRequest
  ) extends zio.aws.ec2.model.CreateLocalGatewayRouteRequest.ReadOnly {
    override val destinationCidrBlock: String =
      impl.destinationCidrBlock(): String
    override val localGatewayRouteTableId: LocalGatewayRoutetableId =
      zio.aws.ec2.model.primitives
        .LocalGatewayRoutetableId(impl.localGatewayRouteTableId())
    override val localGatewayVirtualInterfaceGroupId
        : LocalGatewayVirtualInterfaceGroupId =
      zio.aws.ec2.model.primitives.LocalGatewayVirtualInterfaceGroupId(
        impl.localGatewayVirtualInterfaceGroupId()
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteRequest
  ): zio.aws.ec2.model.CreateLocalGatewayRouteRequest.ReadOnly = new Wrapper(
    impl
  )
}
