package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateEgressOnlyInternetGatewayResponse(
    clientToken: Option[String] = None,
    egressOnlyInternetGateway: Option[
      zio.aws.ec2.model.EgressOnlyInternetGateway
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateEgressOnlyInternetGatewayResponse = {
    import CreateEgressOnlyInternetGatewayResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateEgressOnlyInternetGatewayResponse
      .builder()
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(
        egressOnlyInternetGateway.map(value => value.buildAwsValue())
      )(_.egressOnlyInternetGateway)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CreateEgressOnlyInternetGatewayResponse.ReadOnly =
    zio.aws.ec2.model.CreateEgressOnlyInternetGatewayResponse
      .wrap(buildAwsValue())
}
object CreateEgressOnlyInternetGatewayResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateEgressOnlyInternetGatewayResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateEgressOnlyInternetGatewayResponse =
      zio.aws.ec2.model.CreateEgressOnlyInternetGatewayResponse(
        clientToken.map(value => value),
        egressOnlyInternetGateway.map(value => value.asEditable)
      )
    def clientToken: Option[String]
    def egressOnlyInternetGateway
        : Option[zio.aws.ec2.model.EgressOnlyInternetGateway.ReadOnly]
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getEgressOnlyInternetGateway: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.EgressOnlyInternetGateway.ReadOnly
    ] = AwsError.unwrapOptionField(
      "egressOnlyInternetGateway",
      egressOnlyInternetGateway
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateEgressOnlyInternetGatewayResponse
  ) extends zio.aws.ec2.model.CreateEgressOnlyInternetGatewayResponse.ReadOnly {
    override val clientToken: Option[String] =
      scala.Option(impl.clientToken()).map(value => value: String)
    override val egressOnlyInternetGateway
        : Option[zio.aws.ec2.model.EgressOnlyInternetGateway.ReadOnly] = scala
      .Option(impl.egressOnlyInternetGateway())
      .map(value => zio.aws.ec2.model.EgressOnlyInternetGateway.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateEgressOnlyInternetGatewayResponse
  ): zio.aws.ec2.model.CreateEgressOnlyInternetGatewayResponse.ReadOnly =
    new Wrapper(impl)
}
