package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.CapacityReservationId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CapacityReservationTarget(
    capacityReservationId: Option[CapacityReservationId] = None,
    capacityReservationResourceGroupArn: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CapacityReservationTarget = {
    import CapacityReservationTarget.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CapacityReservationTarget
      .builder()
      .optionallyWith(
        capacityReservationId.map(value =>
          CapacityReservationId.unwrap(value): java.lang.String
        )
      )(_.capacityReservationId)
      .optionallyWith(
        capacityReservationResourceGroupArn.map(value =>
          value: java.lang.String
        )
      )(_.capacityReservationResourceGroupArn)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CapacityReservationTarget.ReadOnly =
    zio.aws.ec2.model.CapacityReservationTarget.wrap(buildAwsValue())
}
object CapacityReservationTarget {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CapacityReservationTarget
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CapacityReservationTarget =
      zio.aws.ec2.model.CapacityReservationTarget(
        capacityReservationId.map(value => value),
        capacityReservationResourceGroupArn.map(value => value)
      )
    def capacityReservationId: Option[CapacityReservationId]
    def capacityReservationResourceGroupArn: Option[String]
    def getCapacityReservationId: ZIO[Any, AwsError, CapacityReservationId] =
      AwsError.unwrapOptionField("capacityReservationId", capacityReservationId)
    def getCapacityReservationResourceGroupArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "capacityReservationResourceGroupArn",
        capacityReservationResourceGroupArn
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CapacityReservationTarget
  ) extends zio.aws.ec2.model.CapacityReservationTarget.ReadOnly {
    override val capacityReservationId: Option[CapacityReservationId] = scala
      .Option(impl.capacityReservationId())
      .map(value => zio.aws.ec2.model.primitives.CapacityReservationId(value))
    override val capacityReservationResourceGroupArn: Option[String] = scala
      .Option(impl.capacityReservationResourceGroupArn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CapacityReservationTarget
  ): zio.aws.ec2.model.CapacityReservationTarget.ReadOnly = new Wrapper(impl)
}
