package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{NetworkInterfaceId, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AssignIpv6AddressesRequest(
    ipv6AddressCount: Option[Integer] = None,
    ipv6Addresses: Option[Iterable[String]] = None,
    ipv6PrefixCount: Option[Integer] = None,
    ipv6Prefixes: Option[Iterable[String]] = None,
    networkInterfaceId: NetworkInterfaceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AssignIpv6AddressesRequest = {
    import AssignIpv6AddressesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AssignIpv6AddressesRequest
      .builder()
      .optionallyWith(ipv6AddressCount.map(value => value: java.lang.Integer))(
        _.ipv6AddressCount
      )
      .optionallyWith(
        ipv6Addresses.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.ipv6Addresses)
      .optionallyWith(ipv6PrefixCount.map(value => value: java.lang.Integer))(
        _.ipv6PrefixCount
      )
      .optionallyWith(
        ipv6Prefixes.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.ipv6Prefixes)
      .networkInterfaceId(
        NetworkInterfaceId.unwrap(networkInterfaceId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AssignIpv6AddressesRequest.ReadOnly =
    zio.aws.ec2.model.AssignIpv6AddressesRequest.wrap(buildAwsValue())
}
object AssignIpv6AddressesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AssignIpv6AddressesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AssignIpv6AddressesRequest =
      zio.aws.ec2.model.AssignIpv6AddressesRequest(
        ipv6AddressCount.map(value => value),
        ipv6Addresses.map(value => value),
        ipv6PrefixCount.map(value => value),
        ipv6Prefixes.map(value => value),
        networkInterfaceId
      )
    def ipv6AddressCount: Option[Integer]
    def ipv6Addresses: Option[List[String]]
    def ipv6PrefixCount: Option[Integer]
    def ipv6Prefixes: Option[List[String]]
    def networkInterfaceId: NetworkInterfaceId
    def getIpv6AddressCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("ipv6AddressCount", ipv6AddressCount)
    def getIpv6Addresses: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("ipv6Addresses", ipv6Addresses)
    def getIpv6PrefixCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("ipv6PrefixCount", ipv6PrefixCount)
    def getIpv6Prefixes: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("ipv6Prefixes", ipv6Prefixes)
    def getNetworkInterfaceId: ZIO[Any, Nothing, NetworkInterfaceId] =
      ZIO.succeed(networkInterfaceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AssignIpv6AddressesRequest
  ) extends zio.aws.ec2.model.AssignIpv6AddressesRequest.ReadOnly {
    override val ipv6AddressCount: Option[Integer] =
      scala.Option(impl.ipv6AddressCount()).map(value => value: Integer)
    override val ipv6Addresses: Option[List[String]] = scala
      .Option(impl.ipv6Addresses())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val ipv6PrefixCount: Option[Integer] =
      scala.Option(impl.ipv6PrefixCount()).map(value => value: Integer)
    override val ipv6Prefixes: Option[List[String]] = scala
      .Option(impl.ipv6Prefixes())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val networkInterfaceId: NetworkInterfaceId =
      zio.aws.ec2.model.primitives.NetworkInterfaceId(impl.networkInterfaceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AssignIpv6AddressesRequest
  ): zio.aws.ec2.model.AssignIpv6AddressesRequest.ReadOnly = new Wrapper(impl)
}
