package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.NetworkInterfaceId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UnassignPrivateIpAddressesRequest(
    networkInterfaceId: NetworkInterfaceId,
    privateIpAddresses: Option[Iterable[String]] = None,
    ipv4Prefixes: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.UnassignPrivateIpAddressesRequest = {
    import UnassignPrivateIpAddressesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.UnassignPrivateIpAddressesRequest
      .builder()
      .networkInterfaceId(
        NetworkInterfaceId.unwrap(networkInterfaceId): java.lang.String
      )
      .optionallyWith(
        privateIpAddresses.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.privateIpAddresses)
      .optionallyWith(
        ipv4Prefixes.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.ipv4Prefixes)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.UnassignPrivateIpAddressesRequest.ReadOnly =
    zio.aws.ec2.model.UnassignPrivateIpAddressesRequest.wrap(buildAwsValue())
}
object UnassignPrivateIpAddressesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.UnassignPrivateIpAddressesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.UnassignPrivateIpAddressesRequest =
      zio.aws.ec2.model.UnassignPrivateIpAddressesRequest(
        networkInterfaceId,
        privateIpAddresses.map(value => value),
        ipv4Prefixes.map(value => value)
      )
    def networkInterfaceId: NetworkInterfaceId
    def privateIpAddresses: Option[List[String]]
    def ipv4Prefixes: Option[List[String]]
    def getNetworkInterfaceId: ZIO[Any, Nothing, NetworkInterfaceId] =
      ZIO.succeed(networkInterfaceId)
    def getPrivateIpAddresses: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("privateIpAddresses", privateIpAddresses)
    def getIpv4Prefixes: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("ipv4Prefixes", ipv4Prefixes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.UnassignPrivateIpAddressesRequest
  ) extends zio.aws.ec2.model.UnassignPrivateIpAddressesRequest.ReadOnly {
    override val networkInterfaceId: NetworkInterfaceId =
      zio.aws.ec2.model.primitives.NetworkInterfaceId(impl.networkInterfaceId())
    override val privateIpAddresses: Option[List[String]] = scala
      .Option(impl.privateIpAddresses())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val ipv4Prefixes: Option[List[String]] = scala
      .Option(impl.ipv4Prefixes())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.UnassignPrivateIpAddressesRequest
  ): zio.aws.ec2.model.UnassignPrivateIpAddressesRequest.ReadOnly = new Wrapper(
    impl
  )
}
