package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{VpnConnectionId, ClientVpnEndpointId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TerminateClientVpnConnectionsRequest(
    clientVpnEndpointId: ClientVpnEndpointId,
    connectionId: Option[VpnConnectionId] = None,
    username: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TerminateClientVpnConnectionsRequest = {
    import TerminateClientVpnConnectionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TerminateClientVpnConnectionsRequest
      .builder()
      .clientVpnEndpointId(
        ClientVpnEndpointId.unwrap(clientVpnEndpointId): java.lang.String
      )
      .optionallyWith(
        connectionId.map(value =>
          VpnConnectionId.unwrap(value): java.lang.String
        )
      )(_.connectionId)
      .optionallyWith(username.map(value => value: java.lang.String))(
        _.username
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.TerminateClientVpnConnectionsRequest.ReadOnly =
    zio.aws.ec2.model.TerminateClientVpnConnectionsRequest.wrap(buildAwsValue())
}
object TerminateClientVpnConnectionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TerminateClientVpnConnectionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TerminateClientVpnConnectionsRequest =
      zio.aws.ec2.model.TerminateClientVpnConnectionsRequest(
        clientVpnEndpointId,
        connectionId.map(value => value),
        username.map(value => value)
      )
    def clientVpnEndpointId: ClientVpnEndpointId
    def connectionId: Option[VpnConnectionId]
    def username: Option[String]
    def getClientVpnEndpointId: ZIO[Any, Nothing, ClientVpnEndpointId] =
      ZIO.succeed(clientVpnEndpointId)
    def getConnectionId: ZIO[Any, AwsError, VpnConnectionId] =
      AwsError.unwrapOptionField("connectionId", connectionId)
    def getUsername: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("username", username)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TerminateClientVpnConnectionsRequest
  ) extends zio.aws.ec2.model.TerminateClientVpnConnectionsRequest.ReadOnly {
    override val clientVpnEndpointId: ClientVpnEndpointId =
      zio.aws.ec2.model.primitives
        .ClientVpnEndpointId(impl.clientVpnEndpointId())
    override val connectionId: Option[VpnConnectionId] = scala
      .Option(impl.connectionId())
      .map(value => zio.aws.ec2.model.primitives.VpnConnectionId(value))
    override val username: Option[String] =
      scala.Option(impl.username()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TerminateClientVpnConnectionsRequest
  ): zio.aws.ec2.model.TerminateClientVpnConnectionsRequest.ReadOnly =
    new Wrapper(impl)
}
