package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait ServiceType {
  def unwrap: software.amazon.awssdk.services.ec2.model.ServiceType
}
object ServiceType {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.ServiceType
  ): zio.aws.ec2.model.ServiceType = value match {
    case software.amazon.awssdk.services.ec2.model.ServiceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.ServiceType.INTERFACE =>
      val r = Interface
      r
    case software.amazon.awssdk.services.ec2.model.ServiceType.GATEWAY =>
      val r = Gateway
      r
    case software.amazon.awssdk.services.ec2.model.ServiceType.GATEWAY_LOAD_BALANCER =>
      val r = GatewayLoadBalancer
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.ServiceType {
    override def unwrap: software.amazon.awssdk.services.ec2.model.ServiceType =
      software.amazon.awssdk.services.ec2.model.ServiceType.UNKNOWN_TO_SDK_VERSION
  }
  case object Interface extends zio.aws.ec2.model.ServiceType {
    override def unwrap: software.amazon.awssdk.services.ec2.model.ServiceType =
      software.amazon.awssdk.services.ec2.model.ServiceType.INTERFACE
  }
  case object Gateway extends zio.aws.ec2.model.ServiceType {
    override def unwrap: software.amazon.awssdk.services.ec2.model.ServiceType =
      software.amazon.awssdk.services.ec2.model.ServiceType.GATEWAY
  }
  case object GatewayLoadBalancer extends zio.aws.ec2.model.ServiceType {
    override def unwrap: software.amazon.awssdk.services.ec2.model.ServiceType =
      software.amazon.awssdk.services.ec2.model.ServiceType.GATEWAY_LOAD_BALANCER
  }
}
