package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Ipv6Address
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ScheduledInstancesIpv6Address(
    ipv6Address: Option[Ipv6Address] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ScheduledInstancesIpv6Address = {
    import ScheduledInstancesIpv6Address.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ScheduledInstancesIpv6Address
      .builder()
      .optionallyWith(
        ipv6Address.map(value => Ipv6Address.unwrap(value): java.lang.String)
      )(_.ipv6Address)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ScheduledInstancesIpv6Address.ReadOnly =
    zio.aws.ec2.model.ScheduledInstancesIpv6Address.wrap(buildAwsValue())
}
object ScheduledInstancesIpv6Address {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ScheduledInstancesIpv6Address
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ScheduledInstancesIpv6Address =
      zio.aws.ec2.model
        .ScheduledInstancesIpv6Address(ipv6Address.map(value => value))
    def ipv6Address: Option[Ipv6Address]
    def getIpv6Address: ZIO[Any, AwsError, Ipv6Address] =
      AwsError.unwrapOptionField("ipv6Address", ipv6Address)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ScheduledInstancesIpv6Address
  ) extends zio.aws.ec2.model.ScheduledInstancesIpv6Address.ReadOnly {
    override val ipv6Address: Option[Ipv6Address] = scala
      .Option(impl.ipv6Address())
      .map(value => zio.aws.ec2.model.primitives.Ipv6Address(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ScheduledInstancesIpv6Address
  ): zio.aws.ec2.model.ScheduledInstancesIpv6Address.ReadOnly = new Wrapper(
    impl
  )
}
