package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.ImageId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RestoreImageFromRecycleBinRequest(imageId: ImageId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.RestoreImageFromRecycleBinRequest = {
    import RestoreImageFromRecycleBinRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RestoreImageFromRecycleBinRequest
      .builder()
      .imageId(ImageId.unwrap(imageId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.RestoreImageFromRecycleBinRequest.ReadOnly =
    zio.aws.ec2.model.RestoreImageFromRecycleBinRequest.wrap(buildAwsValue())
}
object RestoreImageFromRecycleBinRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.RestoreImageFromRecycleBinRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.RestoreImageFromRecycleBinRequest =
      zio.aws.ec2.model.RestoreImageFromRecycleBinRequest(imageId)
    def imageId: ImageId
    def getImageId: ZIO[Any, Nothing, ImageId] = ZIO.succeed(imageId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RestoreImageFromRecycleBinRequest
  ) extends zio.aws.ec2.model.RestoreImageFromRecycleBinRequest.ReadOnly {
    override val imageId: ImageId =
      zio.aws.ec2.model.primitives.ImageId(impl.imageId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RestoreImageFromRecycleBinRequest
  ): zio.aws.ec2.model.RestoreImageFromRecycleBinRequest.ReadOnly = new Wrapper(
    impl
  )
}
