package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{DateTime, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class RequestSpotInstancesRequest(
    availabilityZoneGroup: Option[String] = None,
    blockDurationMinutes: Option[Integer] = None,
    clientToken: Option[String] = None,
    instanceCount: Option[Integer] = None,
    launchGroup: Option[String] = None,
    launchSpecification: Option[
      zio.aws.ec2.model.RequestSpotLaunchSpecification
    ] = None,
    spotPrice: Option[String] = None,
    `type`: Option[zio.aws.ec2.model.SpotInstanceType] = None,
    validFrom: Option[DateTime] = None,
    validUntil: Option[DateTime] = None,
    tagSpecifications: Option[Iterable[zio.aws.ec2.model.TagSpecification]] =
      None,
    instanceInterruptionBehavior: Option[
      zio.aws.ec2.model.InstanceInterruptionBehavior
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.RequestSpotInstancesRequest = {
    import RequestSpotInstancesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RequestSpotInstancesRequest
      .builder()
      .optionallyWith(
        availabilityZoneGroup.map(value => value: java.lang.String)
      )(_.availabilityZoneGroup)
      .optionallyWith(
        blockDurationMinutes.map(value => value: java.lang.Integer)
      )(_.blockDurationMinutes)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(instanceCount.map(value => value: java.lang.Integer))(
        _.instanceCount
      )
      .optionallyWith(launchGroup.map(value => value: java.lang.String))(
        _.launchGroup
      )
      .optionallyWith(launchSpecification.map(value => value.buildAwsValue()))(
        _.launchSpecification
      )
      .optionallyWith(spotPrice.map(value => value: java.lang.String))(
        _.spotPrice
      )
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(validFrom.map(value => DateTime.unwrap(value): Instant))(
        _.validFrom
      )
      .optionallyWith(validUntil.map(value => DateTime.unwrap(value): Instant))(
        _.validUntil
      )
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .optionallyWith(instanceInterruptionBehavior.map(value => value.unwrap))(
        _.instanceInterruptionBehavior
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.RequestSpotInstancesRequest.ReadOnly =
    zio.aws.ec2.model.RequestSpotInstancesRequest.wrap(buildAwsValue())
}
object RequestSpotInstancesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.RequestSpotInstancesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.RequestSpotInstancesRequest =
      zio.aws.ec2.model.RequestSpotInstancesRequest(
        availabilityZoneGroup.map(value => value),
        blockDurationMinutes.map(value => value),
        clientToken.map(value => value),
        instanceCount.map(value => value),
        launchGroup.map(value => value),
        launchSpecification.map(value => value.asEditable),
        spotPrice.map(value => value),
        `type`.map(value => value),
        validFrom.map(value => value),
        validUntil.map(value => value),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        instanceInterruptionBehavior.map(value => value)
      )
    def availabilityZoneGroup: Option[String]
    def blockDurationMinutes: Option[Integer]
    def clientToken: Option[String]
    def instanceCount: Option[Integer]
    def launchGroup: Option[String]
    def launchSpecification
        : Option[zio.aws.ec2.model.RequestSpotLaunchSpecification.ReadOnly]
    def spotPrice: Option[String]
    def `type`: Option[zio.aws.ec2.model.SpotInstanceType]
    def validFrom: Option[DateTime]
    def validUntil: Option[DateTime]
    def tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def instanceInterruptionBehavior
        : Option[zio.aws.ec2.model.InstanceInterruptionBehavior]
    def getAvailabilityZoneGroup: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZoneGroup", availabilityZoneGroup)
    def getBlockDurationMinutes: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("blockDurationMinutes", blockDurationMinutes)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getInstanceCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("instanceCount", instanceCount)
    def getLaunchGroup: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("launchGroup", launchGroup)
    def getLaunchSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.RequestSpotLaunchSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("launchSpecification", launchSpecification)
    def getSpotPrice: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("spotPrice", spotPrice)
    def getType: ZIO[Any, AwsError, zio.aws.ec2.model.SpotInstanceType] =
      AwsError.unwrapOptionField("type", `type`)
    def getValidFrom: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("validFrom", validFrom)
    def getValidUntil: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("validUntil", validUntil)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
    def getInstanceInterruptionBehavior
        : ZIO[Any, AwsError, zio.aws.ec2.model.InstanceInterruptionBehavior] =
      AwsError.unwrapOptionField(
        "instanceInterruptionBehavior",
        instanceInterruptionBehavior
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RequestSpotInstancesRequest
  ) extends zio.aws.ec2.model.RequestSpotInstancesRequest.ReadOnly {
    override val availabilityZoneGroup: Option[String] =
      scala.Option(impl.availabilityZoneGroup()).map(value => value: String)
    override val blockDurationMinutes: Option[Integer] =
      scala.Option(impl.blockDurationMinutes()).map(value => value: Integer)
    override val clientToken: Option[String] =
      scala.Option(impl.clientToken()).map(value => value: String)
    override val instanceCount: Option[Integer] =
      scala.Option(impl.instanceCount()).map(value => value: Integer)
    override val launchGroup: Option[String] =
      scala.Option(impl.launchGroup()).map(value => value: String)
    override val launchSpecification
        : Option[zio.aws.ec2.model.RequestSpotLaunchSpecification.ReadOnly] =
      scala
        .Option(impl.launchSpecification())
        .map(value =>
          zio.aws.ec2.model.RequestSpotLaunchSpecification.wrap(value)
        )
    override val spotPrice: Option[String] =
      scala.Option(impl.spotPrice()).map(value => value: String)
    override val `type`: Option[zio.aws.ec2.model.SpotInstanceType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.ec2.model.SpotInstanceType.wrap(value))
    override val validFrom: Option[DateTime] = scala
      .Option(impl.validFrom())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val validUntil: Option[DateTime] = scala
      .Option(impl.validUntil())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] = scala
      .Option(impl.tagSpecifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.TagSpecification.wrap(item)
        }.toList
      )
    override val instanceInterruptionBehavior
        : Option[zio.aws.ec2.model.InstanceInterruptionBehavior] = scala
      .Option(impl.instanceInterruptionBehavior())
      .map(value => zio.aws.ec2.model.InstanceInterruptionBehavior.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RequestSpotInstancesRequest
  ): zio.aws.ec2.model.RequestSpotInstancesRequest.ReadOnly = new Wrapper(impl)
}
