package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Region(
    endpoint: Option[String] = None,
    regionName: Option[String] = None,
    optInStatus: Option[String] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.Region = {
    import Region.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.Region
      .builder()
      .optionallyWith(endpoint.map(value => value: java.lang.String))(
        _.endpoint
      )
      .optionallyWith(regionName.map(value => value: java.lang.String))(
        _.regionName
      )
      .optionallyWith(optInStatus.map(value => value: java.lang.String))(
        _.optInStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.Region.ReadOnly =
    zio.aws.ec2.model.Region.wrap(buildAwsValue())
}
object Region {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.Region] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.Region = zio.aws.ec2.model.Region(
      endpoint.map(value => value),
      regionName.map(value => value),
      optInStatus.map(value => value)
    )
    def endpoint: Option[String]
    def regionName: Option[String]
    def optInStatus: Option[String]
    def getEndpoint: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("endpoint", endpoint)
    def getRegionName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("regionName", regionName)
    def getOptInStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("optInStatus", optInStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.Region
  ) extends zio.aws.ec2.model.Region.ReadOnly {
    override val endpoint: Option[String] =
      scala.Option(impl.endpoint()).map(value => value: String)
    override val regionName: Option[String] =
      scala.Option(impl.regionName()).map(value => value: String)
    override val optInStatus: Option[String] =
      scala.Option(impl.optInStatus()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.Region
  ): zio.aws.ec2.model.Region.ReadOnly = new Wrapper(impl)
}
