package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.DateTime
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ProvisionedBandwidth(
    provisionTime: Option[DateTime] = None,
    provisioned: Option[String] = None,
    requestTime: Option[DateTime] = None,
    requested: Option[String] = None,
    status: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ProvisionedBandwidth = {
    import ProvisionedBandwidth.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ProvisionedBandwidth
      .builder()
      .optionallyWith(
        provisionTime.map(value => DateTime.unwrap(value): Instant)
      )(_.provisionTime)
      .optionallyWith(provisioned.map(value => value: java.lang.String))(
        _.provisioned
      )
      .optionallyWith(
        requestTime.map(value => DateTime.unwrap(value): Instant)
      )(_.requestTime)
      .optionallyWith(requested.map(value => value: java.lang.String))(
        _.requested
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ProvisionedBandwidth.ReadOnly =
    zio.aws.ec2.model.ProvisionedBandwidth.wrap(buildAwsValue())
}
object ProvisionedBandwidth {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ProvisionedBandwidth
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ProvisionedBandwidth =
      zio.aws.ec2.model.ProvisionedBandwidth(
        provisionTime.map(value => value),
        provisioned.map(value => value),
        requestTime.map(value => value),
        requested.map(value => value),
        status.map(value => value)
      )
    def provisionTime: Option[DateTime]
    def provisioned: Option[String]
    def requestTime: Option[DateTime]
    def requested: Option[String]
    def status: Option[String]
    def getProvisionTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("provisionTime", provisionTime)
    def getProvisioned: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("provisioned", provisioned)
    def getRequestTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("requestTime", requestTime)
    def getRequested: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("requested", requested)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ProvisionedBandwidth
  ) extends zio.aws.ec2.model.ProvisionedBandwidth.ReadOnly {
    override val provisionTime: Option[DateTime] = scala
      .Option(impl.provisionTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val provisioned: Option[String] =
      scala.Option(impl.provisioned()).map(value => value: String)
    override val requestTime: Option[DateTime] = scala
      .Option(impl.requestTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val requested: Option[String] =
      scala.Option(impl.requested()).map(value => value: String)
    override val status: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ProvisionedBandwidth
  ): zio.aws.ec2.model.ProvisionedBandwidth.ReadOnly = new Wrapper(impl)
}
