package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait NetworkInterfaceCreationType {
  def unwrap
      : software.amazon.awssdk.services.ec2.model.NetworkInterfaceCreationType
}
object NetworkInterfaceCreationType {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.NetworkInterfaceCreationType
  ): zio.aws.ec2.model.NetworkInterfaceCreationType = value match {
    case software.amazon.awssdk.services.ec2.model.NetworkInterfaceCreationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.NetworkInterfaceCreationType.EFA =>
      val r = efa
      r
    case software.amazon.awssdk.services.ec2.model.NetworkInterfaceCreationType.BRANCH =>
      val r = branch
      r
    case software.amazon.awssdk.services.ec2.model.NetworkInterfaceCreationType.TRUNK =>
      val r = trunk
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.NetworkInterfaceCreationType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.NetworkInterfaceCreationType =
      software.amazon.awssdk.services.ec2.model.NetworkInterfaceCreationType.UNKNOWN_TO_SDK_VERSION
  }
  case object efa extends zio.aws.ec2.model.NetworkInterfaceCreationType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.NetworkInterfaceCreationType =
      software.amazon.awssdk.services.ec2.model.NetworkInterfaceCreationType.EFA
  }
  case object branch extends zio.aws.ec2.model.NetworkInterfaceCreationType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.NetworkInterfaceCreationType =
      software.amazon.awssdk.services.ec2.model.NetworkInterfaceCreationType.BRANCH
  }
  case object trunk extends zio.aws.ec2.model.NetworkInterfaceCreationType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.NetworkInterfaceCreationType =
      software.amazon.awssdk.services.ec2.model.NetworkInterfaceCreationType.TRUNK
  }
}
