package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  SecurityGroupId,
  SubnetId,
  RouteTableId,
  VpcEndpointId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyVpcEndpointRequest(
    vpcEndpointId: VpcEndpointId,
    resetPolicy: Option[Boolean] = None,
    policyDocument: Option[String] = None,
    addRouteTableIds: Option[Iterable[RouteTableId]] = None,
    removeRouteTableIds: Option[Iterable[RouteTableId]] = None,
    addSubnetIds: Option[Iterable[SubnetId]] = None,
    removeSubnetIds: Option[Iterable[SubnetId]] = None,
    addSecurityGroupIds: Option[Iterable[SecurityGroupId]] = None,
    removeSecurityGroupIds: Option[Iterable[SecurityGroupId]] = None,
    privateDnsEnabled: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointRequest = {
    import ModifyVpcEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointRequest
      .builder()
      .vpcEndpointId(VpcEndpointId.unwrap(vpcEndpointId): java.lang.String)
      .optionallyWith(resetPolicy.map(value => value: java.lang.Boolean))(
        _.resetPolicy
      )
      .optionallyWith(policyDocument.map(value => value: java.lang.String))(
        _.policyDocument
      )
      .optionallyWith(
        addRouteTableIds.map(value =>
          value.map { item =>
            RouteTableId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.addRouteTableIds)
      .optionallyWith(
        removeRouteTableIds.map(value =>
          value.map { item =>
            RouteTableId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.removeRouteTableIds)
      .optionallyWith(
        addSubnetIds.map(value =>
          value.map { item =>
            SubnetId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.addSubnetIds)
      .optionallyWith(
        removeSubnetIds.map(value =>
          value.map { item =>
            SubnetId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.removeSubnetIds)
      .optionallyWith(
        addSecurityGroupIds.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.addSecurityGroupIds)
      .optionallyWith(
        removeSecurityGroupIds.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.removeSecurityGroupIds)
      .optionallyWith(privateDnsEnabled.map(value => value: java.lang.Boolean))(
        _.privateDnsEnabled
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifyVpcEndpointRequest.ReadOnly =
    zio.aws.ec2.model.ModifyVpcEndpointRequest.wrap(buildAwsValue())
}
object ModifyVpcEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyVpcEndpointRequest =
      zio.aws.ec2.model.ModifyVpcEndpointRequest(
        vpcEndpointId,
        resetPolicy.map(value => value),
        policyDocument.map(value => value),
        addRouteTableIds.map(value => value),
        removeRouteTableIds.map(value => value),
        addSubnetIds.map(value => value),
        removeSubnetIds.map(value => value),
        addSecurityGroupIds.map(value => value),
        removeSecurityGroupIds.map(value => value),
        privateDnsEnabled.map(value => value)
      )
    def vpcEndpointId: VpcEndpointId
    def resetPolicy: Option[Boolean]
    def policyDocument: Option[String]
    def addRouteTableIds: Option[List[RouteTableId]]
    def removeRouteTableIds: Option[List[RouteTableId]]
    def addSubnetIds: Option[List[SubnetId]]
    def removeSubnetIds: Option[List[SubnetId]]
    def addSecurityGroupIds: Option[List[SecurityGroupId]]
    def removeSecurityGroupIds: Option[List[SecurityGroupId]]
    def privateDnsEnabled: Option[Boolean]
    def getVpcEndpointId: ZIO[Any, Nothing, VpcEndpointId] =
      ZIO.succeed(vpcEndpointId)
    def getResetPolicy: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("resetPolicy", resetPolicy)
    def getPolicyDocument: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("policyDocument", policyDocument)
    def getAddRouteTableIds: ZIO[Any, AwsError, List[RouteTableId]] =
      AwsError.unwrapOptionField("addRouteTableIds", addRouteTableIds)
    def getRemoveRouteTableIds: ZIO[Any, AwsError, List[RouteTableId]] =
      AwsError.unwrapOptionField("removeRouteTableIds", removeRouteTableIds)
    def getAddSubnetIds: ZIO[Any, AwsError, List[SubnetId]] =
      AwsError.unwrapOptionField("addSubnetIds", addSubnetIds)
    def getRemoveSubnetIds: ZIO[Any, AwsError, List[SubnetId]] =
      AwsError.unwrapOptionField("removeSubnetIds", removeSubnetIds)
    def getAddSecurityGroupIds: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("addSecurityGroupIds", addSecurityGroupIds)
    def getRemoveSecurityGroupIds: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField(
        "removeSecurityGroupIds",
        removeSecurityGroupIds
      )
    def getPrivateDnsEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("privateDnsEnabled", privateDnsEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointRequest
  ) extends zio.aws.ec2.model.ModifyVpcEndpointRequest.ReadOnly {
    override val vpcEndpointId: VpcEndpointId =
      zio.aws.ec2.model.primitives.VpcEndpointId(impl.vpcEndpointId())
    override val resetPolicy: Option[Boolean] =
      scala.Option(impl.resetPolicy()).map(value => value: Boolean)
    override val policyDocument: Option[String] =
      scala.Option(impl.policyDocument()).map(value => value: String)
    override val addRouteTableIds: Option[List[RouteTableId]] = scala
      .Option(impl.addRouteTableIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.RouteTableId(item)
        }.toList
      )
    override val removeRouteTableIds: Option[List[RouteTableId]] = scala
      .Option(impl.removeRouteTableIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.RouteTableId(item)
        }.toList
      )
    override val addSubnetIds: Option[List[SubnetId]] = scala
      .Option(impl.addSubnetIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.SubnetId(item)
        }.toList
      )
    override val removeSubnetIds: Option[List[SubnetId]] = scala
      .Option(impl.removeSubnetIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.SubnetId(item)
        }.toList
      )
    override val addSecurityGroupIds: Option[List[SecurityGroupId]] = scala
      .Option(impl.addSecurityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.SecurityGroupId(item)
        }.toList
      )
    override val removeSecurityGroupIds: Option[List[SecurityGroupId]] = scala
      .Option(impl.removeSecurityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.SecurityGroupId(item)
        }.toList
      )
    override val privateDnsEnabled: Option[Boolean] =
      scala.Option(impl.privateDnsEnabled()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointRequest
  ): zio.aws.ec2.model.ModifyVpcEndpointRequest.ReadOnly = new Wrapper(impl)
}
